<?php
 
namespace App\Exports;
 
use DB;

use App\Http\Controllers\ReportController;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Events\BeforeExport;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class BonusExport implements FromArray, WithHeadings, WithCustomStartCell, ShouldAutoSize, WithTitle, WithEvents, WithColumnWidths,WithStyles
{
    protected  $tgl1, $tgl2;

    function __construct($tgl1, $tgl2) {
        
        $this->tgl1     = $tgl1;
        $this->tgl2     = $tgl2;

    }
    
    /**
    * @return \Illuminate\Support\Collection
    */
    public function array():array
    {
        
        $data = ReportController::getReportBonus($this->tgl1, $this->tgl2);
        return $data;
        
    }
    
    
    public function startCell(): string
    {
        return 'A1';
    }
    
	/* header di excel */
    public function headings(): array
    {
        return 
        [['Report Bonus Penjualan '.tanggal_indonesia($this->tgl1, false).' s/d '.tanggal_indonesia($this->tgl2, false)],
        ["NO FAKTUR","KODE","NAMA BARANG","QTY"]];
    }    


    public function title(): string
    {
    	return 'Report Bonus Penjualan';
    }
    
    public function columnWidths(): array
    {
        return [
            'A' => 25,
            'B' => 8,    
            'C' => 50,
            'D' => 15,

        ];
    }
    
    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text.
            'A1'    => ['font' => ['bold' => true, 'size' => 14]],

            // Styling a specific cell by coordinate.
            //'B2' => ['font' => ['italic' => true]],

            // Styling an entire column.
            //'A1'  => ['font' => ['size' => 14]],
        ];
    }    
    
    public function registerEvents(): array
    {
        return [

            AfterSheet::class => function (AfterSheet $event) {

                $event->sheet->getDelegate()->getStyle('A2:D2')
                    ->getFill()
                    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('FF00FF00');
              
                 $event->sheet->getDelegate()->freezePane('A3');  
            },

        ];
    }        
    
}


