<?php
 
namespace App\Exports;
 
use DB;

use App\Http\Controllers\ReportController;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Events\BeforeExport;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class PajakExport implements FromCollection, WithHeadings, WithCustomStartCell, ShouldAutoSize, WithTitle, WithEvents, WithColumnWidths,WithStyles, WithColumnFormatting
{
    protected  $tgl1, $tgl2, $sup;

    function __construct($tgl1, $tgl2, $sup) {
        
        $this->tgl1 = $tgl1;
        $this->tgl2 = $tgl2;
        $this->sup  = $sup;
    }
    
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        
        $data = ReportController::exportPajak_XLS($this->tgl1, $this->tgl2, $this->sup);
        return $data;
        
    }
    
    
    public function startCell(): string
    {
        return 'A1';
    }
    
	/* header di excel */
    public function headings(): array
    {
        return [['Report Penjualan '.tanggal_indonesia($this->tgl1, false).' s/d '.tanggal_indonesia($this->tgl2, false)],
        ["Tanggal","No.Faktur","Pelanggan","Alamat","Principel","Nama Produk","Harga Satuan","Jumlah Barang","Sub Total","Diskon/Potongan (Rp)","SubTotal Setelah Diskon","DPP","PPN","Total Penjualan"]];
    }    


    public function title(): string
    {
    	return 'Report Penjualan Pajak';
    }
    
    public function columnWidths(): array
    {
        return [
            'A' => 15,
            'B' => 20,    
            'C' => 35,
            'D' => 50,
            'E' => 35,
            'F' => 50,
            'G' => 20,
            'H' => 20,
            'I' => 20,
            'J' => 20,
            'K' => 20,
            'L' => 20,
            'M' => 20,
            'N' => 20

        ];
    }
    
    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text.
            'A1'    => ['font' => ['bold' => true, 'size' => 14]],

            // Styling a specific cell by coordinate.
            //'B2' => ['font' => ['italic' => true]],

            // Styling an entire column.
            //'A1'  => ['font' => ['size' => 14]],
        ];
    }    

    public function columnFormats(): array
    {
        return [
            'A' =>NumberFormat::FORMAT_DATE_DDMMYYYY,
            'J' =>NumberFormat::FORMAT_GENERAL_NUMBER,
            'K' =>NumberFormat::FORMAT_GENERAL_NUMBER,
            'L' =>NumberFormat::FORMAT_NUMBER,
            'M' =>NumberFormat::FORMAT_NUMBER,
            'N' =>NumberFormat::FORMAT_NUMBER
            
        ];
    }
    
    public function registerEvents(): array
    {
        return [

            AfterSheet::class => function (AfterSheet $event) {

                $event->sheet->getDelegate()->getStyle('A2:N2')
                    ->getFill()
                    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                    ->getStartColor()
                    ->setARGB('FF00FF00');
              
                 $event->sheet->getDelegate()->freezePane('A3');  
            },

        ];
    }        
    
}


