<?php

namespace App\Http\Controllers;

use Mike42\Escpos\Printer; 
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\RawbtPrintConnector;
use Mike42\Escpos\CapabilityProfile;

use Illuminate\Http\Request;
use DataTables;
use Auth;
use DB;
use Session;
use Redirect;

use App\User;
use App\City;
use App\User_logs;
use App\Setting;
use App\MSAccount;


class AccountController extends Controller
{
    
    public function index(){
        
        return view('account.index');
    }
    
    public function dataAccount(){
    
        $act = MSAccount::orderBy('acct_no', 'ASC')
                        ->get();
                        
        $data=[];
        foreach($act as $dt){
            
            if($dt->is_dk=="D"){ $dbt="DEBET"; }else{ $dbt="KREDIT"; }
            if($dt->acct_tp=="H"){ $tp="HEADER"; }else{ $tp="DETAIL"; }
            
            $row=[];
            $row[] = $dt->acct_no;
            $row[] = $dt->acct_name;
            $row[] = $tp;
            $row[] = $dbt;
            $row[] = $dt->deskripsi;
            $row[] ='<div class="btn-btn">
                        <a onclick="editAcct('.$dt->id.')" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></a>
                      </div>';
            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
        
    }
    
    public function store(Request $request){
        
        $dt = new MSAccount;

        $dt->acct_no        = $request['kode'];
        $dt->acct_name      = ucwords($request['nama']);
        $dt->acct_tp        = $request['tipe'];
        $dt->is_dk          = $request['dk'];
        $dt->deskripsi      = $request['ket'];

        $dt->save();
        
	// insert logs
		$usrnm	= Auth::user()->username;
		
		$title		= 'New Account';
		$content	= 'No.Account '.$request['kode'].' dibuat oleh '.$usrnm;
		$userid	    = Auth::user()->id;

        User_logs::UserLogs($title, $content, $userid);
        		
        echo json_encode(["msg"=>"success"]);
    }
    

    public function edit($id){

        $dt = MSAccount::find($id);
        echo json_encode($dt);

    }

    public function show($id){
        $dt = MSAccount::find($id);
        echo json_encode($dt);
    }
    
    public function update(Request $request, $id){

        $dt = MSAccount::find($id);

        $dt->acct_name      = ucwords($request['nama']);
        $dt->acct_tp        = $request['tipe'];
        $dt->is_dk          = $request['dk'];
        $dt->deskripsi      = $request['ket'];

        $dt->update();
        
	// insert logs
		$usrnm	= Auth::user()->username;
		
		$title		= 'Edit Account';
		$content	= 'No.Account '.$request['kode'].' diedit oleh '.$usrnm;
		$userid	    = Auth::user()->id;

        User_logs::UserLogs($title, $content, $userid);
        
        echo json_encode(["msg"=>"success"]);

    }
 


    
    function printRekap($id){
        
        $kas = Kas::find($id);
        $kasir = User::cekUser($kas->user_id)->username;
        
        $masuk = DTKas::where('kas_id', $id)
                            ->orderBy('project_id','ASC')
                            ->orderBy('tanggal','ASC')
                            ->get();
                            
        $dt = Biaya::where('kas_id', $id)
                        ->get();
                        
        $awal = $kas->saldo_awal;
        
        $tlmasuk=0;
        foreach($masuk as $mm){
            $tlmasuk += $mm->nominal;
        }
        
        $tlbiaya=0;
        $no =1;
        
        foreach($dt as $dd){
            $tlbiaya += $dd->nominal;    
        }
        
        $sisa=$awal + $tlmasuk - $tlbiaya;
        
        return view('biaya.rekap', compact('kas','awal','masuk','dt','tlmasuk','tlbiaya','sisa','kasir','no'));
    }

    public function cekNoUrut($init, $tgl){
        
    	/* cek no terakhir */
		$nourut	= '';
		$tahun	= date('Y', strtotime($tgl));    //date('Y');
		$bulan  = date('m', strtotime($tgl));     //date('m');
        
        $bln='';
        switch($bulan){
            case '01': $bln='I';break;
            case '02': $bln='II';break;  
            case '03': $bln='III';break;  
            case '04': $bln='IV';break;  
            case '05': $bln='V';break;  
            case '06': $bln='VI';break;  
            case '07': $bln='VII';break;  
            case '08': $bln='VIII';break;  
            case '09': $bln='IX';break;  
            case '10': $bln='X';break;  
            case '11': $bln='XI';break;  
            case '12': $bln='XII';break;  
        }
		
		$nomor ="/".$init."/".$bln."/".$tahun;      //0001/RCP/IX/2023
			
		$ada_no	= DB::table('dt_transaksi')
						->select(DB::raw('SUBSTR(MAX(order_no),1,4) as last_no'))
						->where('order_no', 'LIKE', "%$nomor%" )
						->first();
			
		if (!empty($ada_no))
		{
			$no	= $ada_no->last_no + 1;
				
			$nomorbaru 	= sprintf("%04s", $no);		//format: IN/202101/0001
			$nourut = $nomorbaru.$nomor;
			
		} else {
			$nomorbaru = "0001";
			$nourut = $nomorbaru.$nomor;
		}
		
		return $noorder;
    }	        
 
}
