<?php

namespace App\Http\Controllers;

use Mike42\Escpos\Printer; 
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\RawbtPrintConnector;
use Mike42\Escpos\CapabilityProfile;

use Illuminate\Http\Request;
use DataTables;
use Auth;
use DB;
use Session;
use Redirect;

use App\User;
use App\City;
use App\User_logs;
use App\Setting;
use App\ProjectRumah;
use App\Kas;
use App\Biaya;
use App\DTKas;
use App\MSAccount;

use App\Imports\BiayaImport;
use Illuminate\Support\Facades\Input;
use Excel;



class BiayaController extends Controller
{
    
    public function index(){
        
        $prj = ProjectRumah::all();
        $act = MSAccount::where('is_dk','K')
                            ->orderBy('acct_no')
                            ->get();
                            
        $kas = MSAccount::where('acct_tp','H')
                            ->get();
                            
        $kasin= MSAccount::where('is_dk','D')
                            ->get();
                            
        return view('biaya.index', compact('prj','act','kas','kasin'));
    }
    
    public function dataKas(){
    
        $kas = Kas::with('get_project')
                        ->orderBy('periode', 'DESC')
                        ->get();
                        
        $data=[];
        foreach($kas as $dt){
            
            if($dt->kas_tp=="B"){ $tp="BANK"; }else{ $tp="CASH"; }
            
            $row=[];
            $row[] = $dt->get_project->initial;
            $row[] = $dt->periode;
            $row[] = User::cekUser($dt->user_id)->username;
            $row[] = $tp;
            $row[] = MSAccount::get_account($dt->no_acct)->acct_name;
            $row[] = '<div class="text-right">'.number_format($dt->saldo_awal,2).'</div>';
            $row[] = '<div class="text-right">'.number_format($dt->kas_masuk,2).'</div>';
            $row[] = '<div class="text-right">'.number_format($dt->total_biaya,2).'</div>';
            $row[] = '<div class="text-right">'.number_format($dt->saldo_akhir,2).'</div>';
            //$row[] = $dt->deskripsi;
            if($dt->is_closed=="1"){
                $row[]='<div class="btn-btn">
                        <a onclick="printBiaya('.$dt->id.')" class="btn btn-info btn-sm"><i class="fa fa-print"></i></a>
                      </div>';
            }else{
            $row[]=
	              '<div class="btn-group">
                    <a  class="btn btn-flat btn-xs dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    </a>
                        <ul class="dropdown-menu dropdown-menu-right" style="border:2px black solid;" id="dropMenu">
                            <li><a onclick="addKas('.$dt->id.')"><i class="fa fa-plus"></i>Kas Masuk</a></li>
                            <li><a onclick="addBiaya('.$dt->id.')"><i class="fa fa-minus"></i>Input Biaya </a></li>
                            <li><a onclick="printBiaya('.$dt->id.')"><i class="fa fa-print"></i>Print Laporan</a></li>
                            <li><a onclick="closingBiaya('.$dt->id.')"><i class="fa fa-check-square-o"></i>Closing Periode</a></li>
                        </ul>
                    </div>';
            }
            
            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
        
    }
    
    public function store(Request $request){
        
        //return json_encode(['msg'=>'success']);
        
        $act = MSAccount::find($request['actkas']);
        
        $dt = new Kas;
        
        $dt->project_id     = $request['prj'];
        $dt->periode        = $request['masa'];
        $dt->user_id        = Auth::user()->id;
        $dt->kas_tp         = $request['tpkas'];
        $dt->no_acct        = $act->acct_no;
        $dt->deskripsi      = $request['ket'];
        
        $dt->save();
        
	// insert logs
		$usrnm	= Auth::user()->username;
		
		$title		= 'Kas Biaya ';
		$content	= 'Kas '.$act->acct_name.' untuk periode '.$request['masa'].' dibuat oleh '.$usrnm;
		$userid	    = Auth::user()->id;

        User_logs::UserLogs($title, $content, $userid);
        		
        echo json_encode(["msg"=>"success"]);
    }

    function cekPeriode($prd, $tgl){
        $pp=substr($tgl,0,4).'-'.substr($tgl,5,2);  //2023-09
        if($prd == $pp ){ 
            return true;
        }else{
            return false; 
        }
    }

    public function kasmasuk(Request $request){
        
        $kas = Kas::find($request['idkas']);
        $act = MSAccount::find($request['act']);
        
        if($this->cekPeriode($kas->periode, $request['tglkas'])==false){
            return json_encode(['msg'=>'errorperiode']);
        }
        
        $dt = new DTKas;
        $dt->kas_id     = $request['idkas'];
        $dt->project_id = $kas->project_id;
        $dt->tanggal    = $request['tglkas'];
        $dt->no_acct    = $act->acct_no;
        $dt->is_dk      = 'D';
        $dt->is_cb      = $kas->kas_tp;
        $dt->nominal    = $request['nom'];
        $dt->deskripsi  = $request['ketrg'];
        $dt->save();
        
        $kas->kas_masuk     += $request['nom'];
        $kas->saldo_akhir   += $request['nom'];
        $kas->update();
     
        	// insert logs
		$usrnm	= Auth::user()->username;
		
		$title		= 'Kas Masuk';
		$content	= 'Kas Masuk tanggal sebesar '.$request['nom'].' '.tanggal_indonesia(date('Y-m-d'), false).' dibuat oleh '.$usrnm;
		$userid	    = Auth::user()->id;

        User_logs::UserLogs($title, $content, $userid);
        
        echo json_encode(['msg'=>'success']);
        
    }

    function datamasuk($id){
        
        $dt = DTKas::where('kas_id', $id)
                        ->get();
                        
        $data=[];
        foreach($dt as $bb){
            
            $row=[];
            $row[]=tanggal_indonesia($bb->tanggal, false);
            $row[]=$bb->no_acct;
            $row[]='<div class="text-right">'.format_uang($bb->nominal).'&nbsp;&nbsp;</div>';
            $row[]=$bb->deskripsi;

            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
                        
    }


    public function edit($id){

        $dt = Kas::find($id);
        $act= MSAccount::where('acct_no', $dt->no_acct)
                            ->first();
        
        echo json_encode(array_merge(json_decode($act, true), json_decode($dt, true)));

    }

    public function show($id){
        $dt = Kas::find($id);
        echo json_encode($dt);
    }
    
    public function update(Request $request, $id){

        $trx = Transaksi::find($id);
        
        $trx->status_trx    = $request['byr'];
        $trx->referensi     = ucwords(strtolower($request['ref']));
        $trx->deskripsi     = $request['ket'];
        $trx->update();

	// insert logs
		$usrnm	= Auth::user()->username;
		
		//$userlog = New User_logs;
		$title		= 'Edit Transaksii';
		$content	= 'Transaksi '.$trx->trans_no.' diedit oleh '.$usrnm;
		$userid	    = Auth::user()->id;
        
        User_logs::UserLogs($title, $content, $userid);
        
        echo json_encode(["msg"=>"success"]);

    }
 

    function databiaya($id){
        
        $trx= Kas::with('get_project')->find($id);
        
        $dt = DTKas::where('kas_id', $id)
                        ->orderBy('tanggal', 'DESC')
                        ->orderBy('id', 'DESC')
                        ->get();
                        
        $data=[];
        foreach($dt as $bb){
            
            //if(is_null($bb->project_id)){ $prj='';}else{ $prj=ProjectRumah::cek_project($bb->project_id)->initial;}
            
            $row=[];
            $row[]=tanggal_indonesia($bb->tanggal, false);
            $row[]=$trx->get_project->initial;
            $row[]=$bb->no_acct;
            //$row[]=$bb->is_cb;
            $row[]=$bb->is_dk;
            $row[]=$bb->deskripsi;
            $row[]='<div class="text-right">'.number_format($bb->nominal,2).'&nbsp;&nbsp;</div>';
            
            $row[] = '<div class="btn-btn">
                        <a onclick="editdata('.$bb->id.')" class="btn btn-sm btn-flat"><i class="fa fa-edit"></i></a>
                      </div>';

            
            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
                        
    }
    
    function simpanBiaya(Request $request){
        
        $kas = Kas::find($request['id2']);
        $act = MSAccount::find($request['act2']);
        
        if($act->is_dk != "K"){ return json_encode(['msg'=>"error"]); }

        $dt = new DTKas;
        $dt->kas_id     = $kas->id;
        $dt->project_id = $kas->project_id;
        $dt->tanggal    = $request['tgl2'];
        $dt->no_acct    = $act->acct_no;
        $dt->is_dk      = 'K';
        $dt->is_cb      = $kas->kas_tp;
        $dt->nominal    = $request['biaya'];
        $dt->deskripsi  = $request['ketr2'];
        $dt->save();
        
        $kas->total_biaya   += $request['biaya'];
        $kas->saldo_akhir   -= $request['biaya'];
        $kas->update();


	// insert logs
		$usrnm	= Auth::user()->username;
		
		$title		= 'Biaya';
		$content	= 'Biaya sebesar '.$request['biaya'].' '.$request['ketr2'].' telah dikeluarkan kas '.$usrnm;
		$userid	    = Auth::user()->id;

		User_logs::UserLogs($title, $content, $userid);
		
        echo json_encode(["msg"=>"success"]);        
        
    }
    
    function hitungsaldo($id){
        
        $kas = Kas::find($id);
        $dt = DTKas::where('kas_id', $id)
                        ->get();
                        
        $awal = $kas->saldo_awal;
        $tldb=0;
        $tlcr=0;
        
        foreach($dt as $bb){
            if($bb->is_dk=="D"){
                $tldb += $bb->nominal;
            }else{
                $tlcr += $bb->nominal;
            }
        }
        
        $akhir = $awal + $tldb - $tlcr;
                        
        $kas->total_biaya = $tlcr;
        $kas->kas_masuk   = $tldb;
        $kas->saldo_akhir = $akhir;
        $kas->update();
        
        echo json_encode(["saldo"=>number_format($akhir,2)]);
    }
    
    function editbiaya($id){
        
        $dt = DTKas::find($id);
        $act= MSAccount::where('acct_no', $dt->no_acct)
                            ->first();

        //echo json_encode($dt);                            
        
        //echo json_encode(array_merge(json_decode($dt, true), json_decode($act, true)));
        
        $data=["id"=>$dt->id, "project_id"=>$dt->project_id, "tanggal"=>$dt->tanggal, "nominal"=>$dt->nominal, "deskripsi"=>$dt->deskripsi, "id2"=>$act->id];
        echo json_encode($data);
        
        
    }
    
    function simpaneditbiaya(Request $request, $id){
        
        $dt  = DTKas::find($request['id2']);
        $kas = Kas::find($dt->kas_id);
        $act = MSAccount::find($request['act2']);
        
        $nom_old = $dt->nominal;
        $nom_new = $request['biaya'];

        $dt->tanggal    = $request['tgl2'];
        $dt->no_acct    = $act->acct_no;
        //$dt->project_id = $request['project'];
        $dt->nominal    = $nom_new;
        $dt->deskripsi  = $request['ketr2'];
        $dt->update();
        
        //$kas->total_biaya   = $kas->total_biaya + ($nom_new-$nom_old);
        //$kas->saldo_akhir   = $kas->saldo_akhir - ($nom_new-$nom_old);
        //$kas->update();


	// insert logs
		$usrnm	= Auth::user()->username;
		
		$title		= 'Edit Biaya';
		$content	= $request['ketr2'].' - '.$nom_new.' diedit '.$usrnm;
		$userid	    = Auth::user()->id;

		User_logs::UserLogs($title, $content, $userid);
		
        echo json_encode(["msg"=>"success"]);           
    }
    
    function printRekap($id){
        
        $kas = Kas::find($id);
        $kasir = User::cekUser($kas->user_id)->username;
        
        $dt = DTKas::where('kas_id', $id)
                            //->orderBy('project_id','ASC')
                            ->orderBy('tanggal','ASC')
                            ->get();
                            
        $awal = $kas->saldo_awal;
        
        $tlmasuk=0;
        $tlbiaya=0;
        $no =1;
        
        $data=[];
        $row=[];
        
        /* saldo awal */
        $row[]='';
        $row[]='';
        $row[]='';
        $row[]='Saldo Awal';
        $row[]=format_uang($awal);
        $row[]='';
        $row[]=format_uang($awal);
        $data[]=$row;
        
        $saldo=$awal;
        
        $tldb=0;
        $tlcr=0;
        
        foreach($dt as $dd){
            
            if(is_null($dd->project_id)){ $prj='';}else{ $prj=ProjectRumah::cek_project($dd->project_id)->initial;}
            
            $row=[];
            $row[]=tanggal_indonesia($dd->tanggal, false);
            $row[]=$dd->no_acct;
            $row[]=$prj;
            $row[]=$dd->deskripsi;
            if($dd->is_dk=="D"){
                
                $tldb += $dd->nominal;
                
                $row[]=format_uang($dd->nominal);
                $row[]='';
                $saldo += $dd->nominal;
            }else{
                
                $tlcr += $dd->nominal;
                
                $row[]='';
                $row[]=format_uang($dd->nominal);
                $saldo -= $dd->nominal;
            }
            
            $row[]=format_uang($saldo);
            
            $data[]=$row;
        }
        
        return view('biaya.rekap', compact('kas','awal','data','kasir', 'tldb', 'tlcr'));
        
        
    }
    
    
    function posting(Request $request){
        
        $kas = Kas::find($request['idbiaya']);
        if($kas->kas_tp=="B"){ $ket="BANK"; }else{ $ket="CASH"; }
        
        $thnprd=substr($kas->periode,0,4);
        $blnprd=substr($kas->periode,5,2);
        
        if($blnprd=="12"){
            $thn = $thnprd+1 ;
            $bln = "01";
        }else{
            $thn = $thnprd;
            $bln = sprintf("%02s", $blnprd+1);
        }
        
        $prd=$thn.'-'.$bln;
        
        $sld=$kas->saldo_akhir;
        
        $cekdt = Kas::where('periode', $prd)
                        ->where('project_id', $kas->project_id)
                        ->first();
        
        if(empty($cekdt)){    
            $dt = new Kas;
            $dt->periode    = $prd;
            $dt->project_id = $kas->project_id;
            $dt->kas_tp     = $kas->kas_tp;
            $dt->no_acct    = $kas->no_acct;
            $dt->user_id    = Auth::user()->id;
            $dt->saldo_awal = $sld;
            $dt->saldo_akhir= $sld;
            $dt->deskripsi  = 'kas '.$ket.' untuk periode '.$thn.'-'.$bln;
            $dt->save();
        }else{
            $cekdt->saldo_awal = $sld;    
            $cekdt->saldo_akhir= $sld;
            $cekdt->update();
        }
        
        $kas->is_closed=1;
        $kas->update();
        
	// insert logs
		$usrnm	= Auth::user()->username;
		
		$title		= 'Closing Kas';
		$content	= 'Kas '.$ket. ' periode '.$kas->periode.' sudah diclosing '.$usrnm;
		$userid	    = Auth::user()->id;

		User_logs::UserLogs($title, $content, $userid);        
        return json_encode(['msg'=>"success"]);
        
    }
    
    
    
    
    
    

    public function cekNoUrut($init, $tgl){
        
    	/* cek no terakhir */
		$nourut	= '';
		$tahun	= date('Y', strtotime($tgl));    //date('Y');
		$bulan  = date('m', strtotime($tgl));     //date('m');
        
        $bln='';
        switch($bulan){
            case '01': $bln='I';break;
            case '02': $bln='II';break;  
            case '03': $bln='III';break;  
            case '04': $bln='IV';break;  
            case '05': $bln='V';break;  
            case '06': $bln='VI';break;  
            case '07': $bln='VII';break;  
            case '08': $bln='VIII';break;  
            case '09': $bln='IX';break;  
            case '10': $bln='X';break;  
            case '11': $bln='XI';break;  
            case '12': $bln='XII';break;  
        }
		
		$nomor ="/".$init."/".$bln."/".$tahun;      //0001/RCP/IX/2023
			
		$ada_no	= DB::table('dt_transaksi')
						->select(DB::raw('SUBSTR(MAX(order_no),1,4) as last_no'))
						->where('order_no', 'LIKE', "%$nomor%" )
						->first();
			
		if (!empty($ada_no))
		{
			$no	= $ada_no->last_no + 1;
				
			$nomorbaru 	= sprintf("%04s", $no);		//format: IN/202101/0001
			$nourut = $nomorbaru.$nomor;
			
		} else {
			$nomorbaru = "0001";
			$nourut = $nomorbaru.$nomor;
		}
		
		return $noorder;
    }	    
    
    
    public function import_data(){
        return view('biaya.upload');
    }	

    public function importBiaya(Request $request) {
        
        if($request->file=="")
        	{ Session::flash('error','File harus dipilih ! ');
    		  return back();
		    }
        

        Excel::import(new BiayaImport, request()->file('file'));  
            
    	Session::flash('sukses','Data Berhasil Diimport ! ');
    	return back();
        
    }    
    
    
 
}
