<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use App\Customer;
use App\City;
use App\Project;
use App\MSRumah;
use App\Salesman;
use App\User;
use App\User_logs;
use DataTables;


class CustomerController extends Controller
{
   public function index()
   {
        $kota = City::all();

		return view('customer.index', compact('kota')); 
   }

    public function jumlahCustomer(){
        $cus = Customer::count();
                        
        echo json_encode(["jumlah"=>$cus]);
    }

   public function listData()
   {
     
    $customer = Customer::with('get_city')
                    ->orderBy('ms_customer.cus_name','desc')
					->get();
   
     $data = array();
     foreach($customer as $list){
       
       if($list->is_customer=="1"){ $sts="Customer"; }else{ $sts="Calon"; }
       
       $row = [];
       $row[] = $list->cus_name; 
       $row[] = $list->cus_address.'<br>'.$list->get_city->city_name;
       $row[] = $list->cus_hp;
       $row[] = $sts;
       $row[] = $list->deskripsi;

       $row[] = '<div class="btn-btn">
               <a onclick="editForm('.$list->id_cust.')" class="btn btn-flat btn-xs"><i class="fa fa-pencil"></i></a>
               <a onclick="infocust('.$list->id_cust.')" class="btn btn-flat btn-xs"><i class="fa fa-info-circle"></i></a>
               </div>';
       $data[] = $row;
     }

     $output = array("data" => $data);
     return response()->json($output);
	 
   }

   public function store(Request $request)
   {

        $customer = new Customer;
      
	    $customer->cus_name     = strtoupper($request['nama']);
        $customer->cus_address  = ucwords(strtolower($request['alamat']));
        $customer->cus_kota     = $request['kota'];
        $customer->cus_hp	    = $request['telp'];
        $customer->cus_noid     = $request['nik'];
        $customer->no_npwp      = $request['npwp'];
        $customer->is_customer  = $request['sts'];
        $customer->email        = $request['email'];
        $customer->deskripsi    = $request['ket'];
	    $customer->user_id	    = Auth::user()->id;
        $customer->save();

      // insert logs
        $usrnm	= Auth::user()->username;
        $userlog = New User_logs;
        $userlog->title		= 'New Master Customer';
        $userlog->content	= 'Customer '.$request['nama'].' berhasil ditambah oleh '.$usrnm;
        $userlog->user_id	= Auth::user()->id;
        $userlog->save();		
      
        echo json_encode(array('msg'=>'success'));
   }
   
   public function show($id){
       $cust = Customer::find($id);
       echo json_encode($cust);
   }

   public function edit($id)
   {
     $customer = Customer::find($id);
     echo json_encode($customer);
   }

   public function update(Request $request, $id)
   {
        $customer = Customer::find($id);
      
	    $customer->cus_name     = $request['nama'];
        $customer->cus_address  = $request['alamat'];
        $customer->cus_kota     = $request['kota'];
        $customer->cus_hp	    = $request['telp'];
        $customer->cus_noid     = $request['nik'];
        $customer->is_customer  = $request['sts'];
        $customer->deskripsi    = $request['ket'];
        $customer->no_npwp      = $request['npwp'];
	    $customer->user_id	    = Auth::user()->id;
        $customer->update();

      // insert logs
        $usrnm	= Auth::user()->username;
        $userlog = New User_logs;
        $userlog->title		    = 'Edit Master Customer';
        $userlog->content	    = 'Customer '.$request['nama'].' berhasil diedit oleh '.$usrnm;
        $userlog->user_id	    = Auth::user()->id;
        $userlog->save();	
      
        echo json_encode(array('msg'=>'success'));
   }
   
/* untuk salesman via hp */   
   public function index_customer(){
       $sls = Salesman::where('user_id', Auth::user()->id)->first();
       $area = MSArea::where('id', $sls->area)->get();
       
       return view('order.index_customer', compact('kota', 'area'));
   }
   
   public function masterCustomer(){
       
       $sls = Salesman::where('user_id', Auth::user()->id)->first();
       $cust = Customer::where('cus_area', $sls->area)
                            ->orderBy('cus_name')
                            ->get();
                            
        $data=[];
        foreach($cust as $list)
        {
            $row=[];
            
            $row[] = '<div class="card" style="width:auto; height:auto; margin:auto;">
                        <div class="card-block">
                            <div class="card-body">
                                <h4>'.$list->cus_name.'</h4>
                                <h6>'.$list->cus_address.'</h6>
                                <h6>'.City::cekKota($list->cus_kota)->city_name.'</h6>
                                <h5>Telp: '.$list->cus_telp.'</h5>
                                <h6>Area: '.Area::cekArea($list->cus_area)->area_name.'<h6>
                            </div>
                        </div>';
                
            $data[]=$row;
        }
        
        $output = ['data' => $data];
        return response()->json($output);
   }
   
   function printdata($tp){
       
       if($tp=="1"){
           $cus = Customer::where('is_customer',1)
                            ->orderby('cus_name')
                            ->get();
                            
            $jdl='DATA CUSTOMER';
       }else{
           $cus = Customer::where('is_customer',0)
                            ->orderby('cus_name')
                            ->get();
                            
            $jdl='DATA CALON CUSTOMER';
       }
       
       $no=1;
       
       return view('customer.viewcustomer', compact('cus', 'jdl','no'));
       
   }

}
