<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use Redirect;
use DB;
use App\Gudang;
use App\User_logs;

class GudangController extends Controller
{
    public function index()
    {
		return view('gudang.index');
    }

    public function listData()
    {
	    $dt = Gudang::all();
	    
        $data = [];
        foreach($dt as $list){
            
            if($list->is_utama==1){ $sts='<label class="label-success">&nbsp;Ya&nbsp;</label>'; }else{ $sts='<label class="label-danger">&nbsp;Tidak&nbsp;</label>'; }
       
            $row = [];
            $row[] = $list->kode;
            $row[] = $list->nama;
	        $row[] = $list->alamat;
	        $row[] = $sts;
            $row[] = '<div class="btn-btn">
                        <a onclick="editForm('.$list->id.')" class="btn btn-primary btn-sm"><i class="fa fa-pencil" ></i></a>
                    </div>';
            $data[] = $row;
        }

        return response()->json(["data"=>$data]);
	 
    }

    public function store(Request $request)
    {
        $utm = $request['utama'];
        
        $ada_data=0;
        
        if($utm==1){
		    $ada_data = Gudang::where('is_utama',1)
		                            ->count(); }
						
		if ($ada_data>0)
		{
			return json_encode(['msg'=>'error']);
			
		}else{
		   
    		$dt = new Gudang;
    		
    		$dt->kode 	    = strtoupper($request['kode']);
    		$dt->nama 	    = $request['nama'];
    		$dt->alamat	    = $request['alamat'];
    		$dt->is_utama	= $request['utama'];
    		$dt->user_id  	= Auth::user()->id;
    		$dt->save();
    		
    // insert logs
    		$usrnm	= Auth::user()->username;
    		$kd	    = $request['kode'];
    		
    		$userlog = New User_logs;
    		$userlog->title		= 'Tambah Gudang';
    		$userlog->content	= 'Gudang '.$kd.' berhasil ditambahkan oleh '.$usrnm;
    		$userlog->user_id	= Auth::user()->id;
    		$userlog->save();	  
    	  
    		echo json_encode(array('msg'=>'success'));
		}
    }

    public function edit($id)
    {
        $dt = Gudang::find($id);
        echo json_encode($dt);
    }

    public function show($id){
        $dt = Gudang::find($id);
        echo json_encode($dt);        
    }

    public function update(Request $request, $id)
    {

            $dt = Gudang::find($id);
          
    	    $kd	= $dt->kode;
            $dt->nama 	    = $request['nama'];
    	    $dt->alamat     = $request['alamat'];
    	   
            $dt->update();
    
    // insert logs
    		$usrnm	= Auth::user()->username;
    		
    		$userlog = New User_logs;
    		$userlog->title		= 'Edit Gudang';
    		$userlog->content	= 'Gudang '.$kd.' berhasil diedit oleh '.$usrnm;
    		$userlog->user_id	= Auth::user()->id;
    		$userlog->save();	  
    		
    	    echo json_encode(array('msg'=>'success'));
		
    }

}
