<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;

use App\Category;
use App\Product;
use App\Supplier;
use App\Customer;
use App\Setting;
use App\ProjectRumah;
use App\MSRumah;

use App\User;
use App\User_logs;


class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
		$this->middleware('auth');
    }


    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $awal = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
        $akhir = date('Y-m-d');

        $v_until = Setting::first();
        
        $tanggal = $awal;
	    $tglnow  = date('Y-m-d');
        $sss     = Setting::first();
        

		$UserLog	= User_logs::orderBy('created_at','DESC')
		                       ->limit(100)->get();
		
        $valstatus  = SettingController::CekValidStatus();
        $masa_aktif = SettingController::HitungMasaAktif();
        $valid_info ="";
        
        if($valstatus==false)
        {
            $valid_info = "Masa aktif sudah expired, Hubungi Programmer ";
        }		
		
		$prj = ProjectRumah::all();
		$ganjil = true;

        $dt = DB::select(DB::raw('SELECT tbl_a.project_id, tbl_a.project_name, unit, sold FROM 
                        (SELECT a.project_id,b.project_name, COUNT(*) AS unit FROM ms_rumah a 
                        LEFT JOIN ms_project b ON (a.project_id=b.id) GROUP BY 1,2) AS tbl_a
                        LEFT JOIN 
                        (SELECT a.project_id,b.project_name, COUNT(*) AS sold FROM ms_rumah a 
                        LEFT JOIN ms_project b ON (a.project_id=b.id) WHERE a.is_sold=1 GROUP BY 1,2) AS tbl_b
                        ON (tbl_a.project_id=tbl_b.project_id)
                        GROUP BY 1,2,3,4'));

		return view('home.admin', 
		    compact('UserLog','v_until','valid_info','masa_aktif','prj','dt','ganjil'));
    }
    
    
    public function userLogs(){
        
   		$ll	= User_logs::orderBy('created_at','DESC')
		                       ->limit(50)->get();
		                       
		$data=[];                    
		foreach($ll as $log){
		    $row=[];
            $row[]='<li>'.$log->created_at.'
                		<strong><div class="user-timeline-title" style="font-size:12px">'.$log->title.'</div></strong>
                		<div class="user-timeline-description" style="font-size:12px">'.$log->content.'</div><br>
                	</li>';
		    $data[]=$row;
		}
		
		return response()->json(["data"=>$data]);
    }
    

}
