<?php

namespace App\Http\Controllers;

use Mike42\Escpos\Printer; 
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\RawbtPrintConnector;
use Mike42\Escpos\CapabilityProfile;

use Illuminate\Http\Request;
use DataTables;
use Auth;
use DB;
use Session;
use Redirect;

use App\User;
use App\City;
use App\User_logs;
use App\Setting;
use App\ProjectRumah;
use App\HutangProject;
use App\HutangBayar;



class HutangController extends Controller
{

    public function index(){

        $prj=ProjectRumah::all();

        return view('hutang.index',compact('prj'));
    }
    
    public function data($id){
        
        if($id=="0"){
            $hut= HutangProject::with('get_project')
                        ->orderBy('tanggal','ASC')
                        ->get();
            
        }else{
            $pj = ProjectRumah::find($id);
            $hut= HutangProject::with('get_project')
                        ->where('project_id', $id)
                        ->orderBy('tanggal','ASC')
                        ->get();
        }
                        
        $data=[];
        foreach($hut as $dt){
            
            $sts='';
            if($dt->is_lunas=="1"){
                $sts='<label class="label-success">&nbsp;Lunas&nbsp; </label>';
            }
            
            $row=[];
            $row[] = $dt->get_project->project_name;
            $row[] = tanggal_indonesia($dt->tanggal, false);
            $row[] = '<div class="text-right"><b>'.format_uang($dt->nominal).'</b></div>';
            $row[] = '<div class="text-right"><b>'.format_uang($dt->pembayaran).'</b></div>';
            $row[] = $sts;
            $row[] = $dt->deskripsi;
            
            if($dt->is_sold=="1"){
                $row[] = '<div class="btn-group">
                        <a onclick="infoHutang('.$dt->id.')" class="btn btn-sm btn-flat"><i class="fa fa-info-circle"></i></a>
                      </div>';
                
            }else{
                $row[] = '<div class="btn-group">
                        <a onclick="pembayaran('.$dt->id.')" class="btn btn-sm btn-flat"><i class="fa fa-money"></i></a>
                      </div>';
            }
            
            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
        
    }
    
    public function store(Request $request){
        
        $id=$request['id'];
        $prj= ProjectRumah::find($id);
        
        $hut = new HutangProject;
        
        $hut->project_id    = $id;
        $hut->tanggal       = $request['tgl'];
        $hut->nominal       = $request['ttl'];
        $hut->user_id       = Auth::user()->id;
        $hut->deskripsi     = $request['ket'];
        $hut->save();
        
	// insert logs
		$usrnm	= Auth::user()->username;

		$title		= 'Hutang Project';
		$content	= 'Hutang '.$prj->project_name.' sebesar RP. '.$request['ttl'].' berhasil ditambahkan oleh '.$usrnm;
		$usrid	    =  Auth::user()->id;

        User_logs::UserLogs($title, $content, $usrid);
        
        echo json_encode(["msg"=>"success"]);
    }
    

    public function edit($id){
        $dt = HutangProject::find($id);
        $prj= ProjectRumah::find($dt->project_id);

        $data=["id"=>$dt->id, "nominal"=>$dt->nominal, "deskripsi"=>$dt->deskripsi,
                "project_name"=>$prj->project_name, "pembayaran"=>$dt->pembayaran,"sisa"=>$dt->nominal-$dt->pembayaran];
        
        echo json_encode($data);

    }    
    

    public function show($id){
        $dt = HutangProject::find($id);
        echo json_encode($dt);
    }
    
    function databayar($id){
        
        $trx= HutangProject::find($id);
        $dt = HutangBayar::where('hutang_id', $id)
                        ->get();
                        
        $data=[];
        foreach($dt as $cc){
            
            $tp='';
            switch($cc->type_bayar){
                case "1": $tp="TRANSFER"; break;
                case "2": $tp="CASH"; break;
                case "3": $tp="CEK/GIRO"; break;
            }
            
            $row=[];
            $row[]=tanggal_indonesia($cc->tgl_bayar, false);
            $row[]='<div class="text-right">'.format_uang($cc->nominal).'&nbsp;&nbsp;</div>';
            $row[]=$tp;
            $row[]=$cc->deskripsi;
            $row[] = '<div class="btn-btn">
                        <a onclick="editKeterangan('.$cc->id.')" class="btn btn-sm btn-flat"><i class="fa fa-edit"></i></a>
                      </div>';

            
            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
                        
    }
    
    function simpanBayar(Request $request){
        
        $idtrx  = $request['id2'];
        $trx    = HutangProject::find($idtrx);
        $prj    = ProjectRumah::find($trx->project_id);

        $ccl = new HutangBayar;

        $ccl->hutang_id     = $idtrx;
        $ccl->tgl_bayar     = $request['tglbayar'];
        $ccl->nominal       = $request['nom'];
        $ccl->type_bayar    = $request['tpbayar'];
        $ccl->deskripsi     = $request['ketrg'];
        $ccl->user_id       = AUth::user()->id;
        
        $ccl->save();
        
        $trx->pembayaran += $request['nom'];
        if(($trx->pembayaran + $request['nom']) == $trx->nominal){ $trx->is_lunas=1; }
        
        $trx->update();

	// insert logs
		$usrnm	= Auth::user()->username;
		
		$title		= 'Pembayaran Hutang';
		$content	= 'Hutang '.$prj->project_name.' sebesar Rp.'.$request['nom'].' berhasil disimpan '.$usrnm;
		$userid	    = Auth::user()->id;

		User_logs::UserLogs($title, $content, $userid);
		
        echo json_encode(["msg"=>"success"]);        
        
    }    
    
    function editKeterangan($id){
        
        $dt = HutangBayar::find($id);
        echo json_encode($dt);
    }
    
    function simpanEdit(Request $request, $id){
        
        $dt = HutangBayar::find($id);

        $dt->tgl_bayar      = $request['tglbayar'];
        $dt->nominal       = $request['nom'];
        $dt->type_bayar     = $request['tpbayar'];
        $dt->deskripsi      = $request['ketrg'];
        $dt->user_id        = Auth::user()->id;
        $dt->update();
        
        echo json_encode(['msg'=>'success']);
    }
    
    public function update(Request $request, $id){

        $prj = ProjectRumah::find($id);
        $prj->initial       = strtoupper($request['ini']);
        $prj->address       = ucwords(strtolower($request['alm']));
        $prj->kota          = ucwords(strtolower($request['kota']));
        $prj->deskripsi     = $request['ket'];
  
        $prj->update();
        

	// insert logs
		$usrnm	= Auth::user()->username;
		
		$userlog = New User_logs;
		$userlog->title		= 'Edit Project';
		$userlog->content	= 'Project '.$prj->project_name.' berhasil diedit oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();

		echo json_encode(['msg'=>'success']);        
        
    }
 

}
