<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use App\Pegawai;
use App\Jabatan;
use App\Kasbon;
use App\User;
use App\User_logs;
use DataTables;


class KasbonController extends Controller
{
    public function index()
    {
        return view('kasbon.index');
    }

    public function dataKasbon(){
        
        $dt = DB::table('dt_kasbon as A')
                    ->select('A.peg_id', 'B.nip','B.nama', 'C.jabatan')
                    ->addselect(DB::raw('SUM(nominal) as tlkasbon'))
                    ->leftjoin('ms_pegawai as B', function($join){
                        $join->on('A.peg_id', '=', 'B.id');
                    })
                    ->leftjoin('ms_jabatan as C', function($join){
                        $join->on('B.jabatan_id','=', 'C.id');
                    })
                    ->where('A.is_lunas', 0)
                    ->groupBy('A.peg_id')
                    ->groupBy('B.nip')
                    ->groupBy('B.nama')
                    ->groupBy('C.jabatan')
                    ->orderBy('B.nip','ASC')
                    ->get();
                    
        $data=[];
        foreach($dt as $kb){
            
            $row=[];
            $row[] = $kb->nip;
            $row[] = $kb->nama;
            $row[] = $kb->jabatan;
            $row[] = '<div class="text-right">'.format_uang($kb->tlkasbon).'&nbsp;&nbsp;&nbsp;</div>';
            $row[] = '<div class="btn-btn">
                            <a onclick="listkasbon('.$kb->peg_id.')" class="btn btn-success btn-xs"><i class="fa fa-list"></i></a>
                        </div>';
                        
            $data[]=$row;
            
        }
        
        echo json_encode(['data'=>$data]);
    }

    public function listData($id) {
     
        $kb = Kasbon::where('peg_id', $id)
                    ->orderBy('periode','DESC')
					->get();
   
        $data = [];
        foreach($kb as $list){
       
            if($list->is_lunas==1){ $sts='&nbsp;&nbsp;<label class="label-success">&nbsp;&nbsp;</label>'; }else{ $sts='&nbsp;&nbsp;<label class="label-danger">&nbsp;&nbsp;</label>'; }
       
            $row = [];
            $row[] = $list->periode;
            $row[] = tanggal_indonesia($list->tgl_kasbon, false); 
            $row[] = '<div class="text-right">'.format_uang($list->nominal).'&nbsp;&nbsp;</div>';
            $row[] = $sts;
            $row[] = $list->deskripsi;
    
            $row[] = '<div class="btn-btn">
                        <a onclick="editForm('.$list->id.')" class="btn btn-flat btn-xs"><i class="fa fa-pencil"></i></a>
                   </div>';
            $data[] = $row;
        }

        return response()->json(['data'=>$data]);
	 
    }
   
    public function listDetail($id) {
     
        $kb = Kasbon::where('peg_id', $id)
                    ->where('is_lunas',0)
                    ->orderBy('periode','DESC')
					->get();
   
        $data = [];
        foreach($kb as $list){
       

            $row = [];
            $row[] = $list->periode;
            $row[] = tanggal_indonesia($list->tgl_kasbon, false); 
            $row[] = '<div class="text-right">'.format_uang($list->nominal).'&nbsp;&nbsp;</div>';
            $row[] = $list->deskripsi;
    
            $data[] = $row;
        }

        return response()->json(['data'=>$data]);
	 
   }   

   public function store(Request $request)
   {

        $dt = new Kasbon;
      
        $dt->peg_id     = $request['id2'];
        $dt->tgl_kasbon = $request['tgl'];
	    $dt->periode    = $request['masa'];
        $dt->nominal    = $request['nom'];
        $dt->deskripsi  = $request['ketrg'];
	    $dt->user_id	= Auth::user()->id;
        $dt->save();

        echo json_encode(array('msg'=>'success'));
   }
   
    public function show($id){
       $dt = Kasbon::find($id);
       echo json_encode($dt);
    }

    public function edit($id)
    {
        $dt = Kasbon::find($id);
        echo json_encode($dt);
    }

    function tampilpegawai($id){
        
        $peg = Pegawai::find($id);
        $jbt = Jabatan::find($peg->jabatan_id);
        
        $dt=['id'=>$peg->id, 'nama'=>$peg->nama, 'nip'=>$peg->nip, 'tgl_kerja'=>$peg->tgl_kerja, 'jabatan'=>$jbt->jabatan];
        
        echo json_encode($dt);
    }

   public function update(Request $request, $id)
   {
        $peg = Pegawai::find($id);
      
        $peg->nip       = $request['nip'];
	    $peg->nama      = strtoupper($request['nama']);
        $peg->alamat    = ucwords(strtolower($request['alamat']));
        $peg->jabatan_id= $request['jbt'];
        $peg->is_gender = $request['sex'];
        $peg->nohp	    = $request['nohp'];
        $peg->noacct    = $request['norek'];
        $peg->bank      = $request['bank'];
        $peg->tgl_kerja = $request['tglkerja'];
        $peg->deskripsi = $request['ket'];
	    $peg->user_id	= Auth::user()->id;
        $peg->update();

      // insert logs
        $usrnm	= Auth::user()->username;
        
        $title		= 'Edit Pegawai';
        $content	= 'Pegawai '.$request['nama'].' berhasil diedit oleh '.$usrnm;
        $userid	    = Auth::user()->id;
        
        User_logs::UserLogs($title, $content, $userid);
        
        echo json_encode(array('msg'=>'success'));
   }


}
