<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\ProductSup;
use App\Supplier;
use App\City;
use App\Stock;
use App\Gudang;
use App\MSPo;
use App\DTPo;
use App\User_logs;
use DataTables;
use DB;
use Auth;
Use Redirect;

class POController extends Controller
{

	public function index()
	{		
		$supplier = Supplier::all();
        $gdg      = Gudang::all();
		return view('purchase.index', compact('supplier','gdg'));
	}
	

	public function history()
	{		
		return view('invoice.history');
	}	


    function getheader()
    {
		$tglnow = date("Y-m-d");

		$po = MSPo::with('get_supplier', 'get_gudang')
							->orderby('po_no','DESC')
							->where('is_received',0)
							->get();
		
		$data = [];
		
		foreach($po as $list)
		{
			$row = [];
            
            $row[] = $list->po_no;
			$row[] = $list->get_gudang->kode;
			$row[] = tanggal_indonesia($list->po_tgl, false);
			$row[] = $list->get_supplier->sup_nama;
			$row[] = $list->po_ppn;
			$row[] = $list->po_disc;
			$row[] = '<div class="text" align="right">'.format_uang($list->po_netto).'&nbsp;&nbsp;</div>';
			$row[] = $list->deskripsi;
			
			if($list->is_received==1){
			    $row[]="";
			}else{
		        $row[] = '<div class="btn-btn">
				                <a onclick="addDetail('.$list->id.')" class="btn btn-success btn-xs"><i class="fa fa-plus"></i></a>
				                <a onclick="editHeader('.$list->id.')" class="btn btn-danger btn-xs"><i class="fa fa-pencil-square-o"></i></a>
				            </div>';	
			}

		   $data[] = $row;
		}

		return response()->json(["data"=>$data]);								
			
    }
    
    function headeredit()
    {

		$inv = Invoice::with('get_supplier', 'get_gudang')
							->where('inv_batal',0)		                    
		                   	->where('inv_posted',1)
		                   	->where('inv_lunas',0)
							->orderby('inv_no','ASC')
							->get();
		
		$data = [];
		
		foreach($inv as $list)
		{
			$row = [];
            
            $row[] = $list->no_urut;
			$row[] = $list->inv_no;
			$row[] = $list->get_gudang->kode;
			$row[] = tanggal_indonesia($list->inv_tgl, false);
			$row[] = tanggal_indonesia($list->inv_jt, false);
			$row[] = $list->get_supplier->sup_nama;
			$row[] = $list->inv_ppn;
			$row[] = $list->inv_disc;
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_netto).'&nbsp;&nbsp;</div>';
			
	        $row[] = '<div class="btn-btn">
				                <a onclick="addDetail('.$list->id.')" class="btn btn-success btn-xs"><i class="fa fa-pencil"></i></a>
		            </div>';	
		   $data[] = $row;
		}

		return response()->json(["data"=>$data]);								
			
    }    
    

///-- create new po
	public function store(Request $request)
	{
		$idsup		= $request['supl'];
		$dsc		= $request['dis'];
		$ppn		= $request['ppn'];
		$tglpo		= $request['tglpo'];

		if ($dsc<0){ return json_encode(array('msg'=>'discerror')); }
		
		$nopo = $this->cekNoPO($tglpo);
		
		$sup	= Supplier::find($idsup);
	
		$po	= New MSPo;
		
		$po->po_no	    = $nopo;
		$po->gudang_id  = $request['tuju'];
		$po->supp_id	= $idsup;
		$po->po_tgl	    = $tglpo;
		$po->po_disc	= $dsc;
		$po->po_ppn	= $ppn;
		$po->deskripsi = $request['ket'];
		$po->user_id	= Auth::user()->id;
		
		$po->save();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$title		= 'PO Baru '.$nopo;
			$content	= 'PO No.'.$nopo.' '.$sup->sup_nama.' berhasil dicreate oleh '.$usrnm;
			$userid	= Auth::user()->id;

            User_logs::UserLogs($title, $content, $userid);

			echo json_encode(array('msg'=>'success'));
			       			
	}
	
    public static function cekNoPO($tgl){
    	/* cek no terakhir    001/PTSWA/PO/VIII/2023 */
		$nopo	= '';
		$tahun	= date('Y', strtotime($tgl));    //date('Y');
		$bulan  = date('m', strtotime($tgl));     //date('m');
		$init   = 'PTSWA';
        
        $bln='';
        switch($bulan){
            case '01': $bln='I';break;
            case '02': $bln='II';break;  
            case '03': $bln='III';break;  
            case '04': $bln='IV';break;  
            case '05': $bln='V';break;  
            case '06': $bln='VI';break;  
            case '07': $bln='VII';break;  
            case '08': $bln='VIII';break;  
            case '09': $bln='IX';break;  
            case '10': $bln='X';break;  
            case '11': $bln='XI';break;  
            case '12': $bln='XII';break;  
        }
		
		$nomor ="/SWA/PO/".$bln."/".$tahun;      
			
		$ada_no	= DB::table('ms_po')
						->select(DB::raw('SUBSTR(MAX(po_no),1,4) as last_no'))
						->where('po_no', 'LIKE', "%$nomor%" )
						->first();
			
		if (!empty($ada_no))
		{
			$no	= $ada_no->last_no + 1;
				
			$nomorbaru 	= sprintf("%04s", $no);		//format: IN/202101/0001
			$nopo = $nomorbaru.$nomor;
			
		} else {
			$nomorbaru = "0001";
			$nopo = $nomorbaru.$nomor;
		}
		
		return $nopo;
    }			
	
	
	public function update(Request $request, $id){
	    
	    $dis    = $request['dis'];
	    $ppn    = $request['ppn'];
	    
	    $mpo = MSPo::find($id);	 
	    $sup = Supplier::find($mpo->supp_id);
     
	    $mpo->gudang_id     = $request['tuju'];
	    $mpo->po_disc       = $dis;
	    $mpo->po_ppn        = $ppn;
        $mpo->deskripsi     = $request['ket'];
	    $mpo->update();	            

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$title		= 'Edit PO ';
			$content	= 'PO No.'.$mpo->po_no.' '.$sup->sup_nama.' berhasil diedit oleh '.$usrnm;
			$userid	    = Auth::user()->id;
			
		User_logs::UserLogs($title, $content, $userid);
			
	    echo json_encode(['msg'=>'success']);
	    
	}
	
    public function edit($id)
    {
      $mpo = MSPo::find($id);
      $sup = Supplier::find($mpo->supp_id);
      
      echo json_encode(array_merge(json_decode($sup, true), json_decode($mpo, true)));
    }
    
    public function show($id){
        $dt = MSPo::find($id);
        echo json_encode($dt);
    }

    public function dataDetail($id){
        
        $mpo = MSPo::find($id);
        $dtl = DTPo::where('po_id', $id)
                        ->get();
                        
        $data=[];
        $ttl=0;
        foreach($dtl as $dt){
            
            $jlh=($dt->qty * $dt->harga)-($dt->qty * $dt->harga * $dt->disc/100);
            $ttl+= $jlh;
            
            $row=[];
            $row[]=$dt->product_name;
            $row[]=$dt->satuan.'/'.$dt->isi;
            $row[]='<div style="text-align:right">'.$dt->qty.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';            
            $row[]='<div style="text-align:right">'.format_uang($dt->harga).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div style="text-align:right">'.$dt->disc.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div style="text-align:right">'.format_uang($jlh).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<a onclick="editDetail('.$dt->id.')" class="btn btn-flat btn-xs"><i class="fa fa-pencil"></i></a>';

            
            $data[]=$row;
        }
        
        $row=[];

        $row[]="";
        $row[]="";
        $row[]="";
        $row[]="Sub Total";
        $row[]="";        
        $row[]='<div style="text-align:right">'.format_uang($ttl).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
        $row[]="";
            
        $data[]=$row;     
        
        return response()->json(["data"=>$data]);
    }	
    
    /* untuk edit harga */
    public function DetailEdit($id){
        
        $inv = Invoice::find($id);
        $dtl = InvoiceDetail::with('get_product')
                        ->where('inv_id', $id)
                        ->get();
                        
        $data=[];
        $ttl=0;
        foreach($dtl as $dt){
            
            $jlh=($dt->qty * $dt->harga)-($dt->qty * $dt->harga * $dt->disc_1/100);
            $ttl+= $jlh;
            
            $row=[];
            $row[]=$dt->get_product->nama_brg;
            $row[]=$dt->satuan.'/'.$dt->isi;
            $row[]='<div style="text-align:right">'.$dt->qty.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';            
            $row[]='<div style="text-align:right">'.format_uang($dt->harga).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div style="text-align:right">'.$dt->disc_1.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div style="text-align:right">'.format_uang($jlh).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            
            $row[]='<a onclick="editHarga('.$dt->id.')" class="btn btn-flat btn-xs"><i class="fa fa-pencil"></i></a>';

            $data[]=$row;
        }
        
        $row=[];

        $row[]="";
        $row[]="";
        $row[]="";
        $row[]="Sub Total";
        $row[]="";        
        $row[]='<div style="text-align:right">'.format_uang($ttl).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
        $row[]="";
            
        $data[]=$row;     
        
        return response()->json(["data"=>$data]);
    }	    
    
    public function loadSummary($id){
        
        $mpo = MSPo::find($id);
        $dtl = DTPo::where('po_id', $id)
                            ->get();
        $sub=0;
        foreach($dtl as $list){
            $sub += ($list->qty * $list->harga)-($list->qty * $list->harga * $list->disc/100);
        }
        
        $dis = $sub * $mpo->po_disc /100;
        $ppn = ($sub - $dis) * $mpo->po_ppn/100;
        $ttl = $sub - $dis + $ppn;
        
        $mpo->po_netto    = $ttl-$dis+$ppn;
        $mpo->update();
        
        echo json_encode(["totalpo"=>format_uang($ttl)]);
    }	

    public function listProduk($id, $tp){
        
        if($tp=="2"){
            $prd = DB::table('ms_product as A')
                    ->select('B.id', 'A.nama_brg', 'B.satuan', 'B.isi', 'B.harga')
                    ->leftjoin('product_sup as B', function($join){
                            $join->on('A.id', '=', 'B.product_id');  
                        })
                    ->where('B.sup_id', $id)
                    ->get();
        }else{
            $prd = DB::table('ms_product as A')
                    ->select('A.id', 'A.nama_brg', 'A.satuan', 'A.isi', 'A.harga')
                    ->orderBy('A.nama_brg')
                    ->get();            
        }


		$data = [];
		
		foreach($prd as $list){
			$row = [];
			$row[] = $list->nama_brg;
			$row[] = $list->satuan.'/'.$list->isi ;
            $row[] = '<div style="text-align:right">'.format_uang($list->harga).'</div>' ;
			
  		    $row[] = '<div class="btn-btn">
						<a onclick="selectProduk('.$list->id.')" class="btn btn-primary btn-sm"><i class="fa fa-check"></i></a>
					</div>';

			$data[] = $row;
        }

        return response()->json(["data"=>$data]);        
    }
    
    function tampilProductList($id, $tp){
        
        if($tp=="1"){
            $prd = Product::find($id);
            echo json_encode($prd);
        }else{
            $lst = ProductSup::find($id);
            $prd = Product::find($lst->product_id);
            
            echo json_encode(array_merge(json_decode($prd, true), json_decode($lst, true)));            
        }
    }    
    
    
    public function tampilKemasan($id){
        
        $kms = ProductSub::find($id);
        $prd = Product::find($kms->product_id);
        $dt = $kms->satuan." / ".$kms->volume;
        $brg= $prd->kode_brg.' - '.$prd->nama_brg;
        
        echo json_encode(["kemasan"=>$dt, "harga"=>$kms->hpp, "namaprd"=>$brg]);
    }
    
    public function addDetail(Request $request){

        $idsup  = $request['idsup'];       /* pada form add_detail */
        $idpo   = $request['idpo2'];
        $qty    = $request['qty'];
        $hg     = $request['harga'];
        $tp     = $request['tp'];
        $idprd  = $request['iddetail'];
        
        $po = MSPo::find($idpo);
        
        if($tp=="2"){
            $lst = ProductSup::find($idprd);
            $prd = Product::find($lst->product_id);
            $stn = $lst->satuan;
            $isi = $lst->isi;
        }else{
            $prd = Product::find($idprd);
            $stn = $prd->satuan;
            $isi = $prd->isi;
        }
        
        try{    
            $dt = new DTPo;
            $dt->po_id          = $po->id;
            $dt->product_id     = $prd->id;
            $dt->product_name   = $prd->nama_brg;
            $dt->satuan         = $stn;
            $dt->isi            = $isi;
            $dt->harga          = $hg;
            $dt->disc           = $request['dis1'];
            $dt->qty            = $qty;
            $dt->save();
            
            echo json_encode(['msg'=>'success']);
        }
        catch (Exeption $e){
            return response (['status' => false,'errors' => $e->getMessage()]);
        }
    }
    
    public function editDetail($id){
        
        $dt = InvoiceDetail::find($id);
        echo json_encode($dt);
        
    }
    
    public function simpanEdit(Request $request, $id){

        $dt = InvoiceDetail::find($id);
        $inv = Invoice::find($dt->inv_id);
        
        $hg     = $request['harga'];
        $oldqty = $dt->qty;
        $newqty = $request['qty'];
        
        $dt->disc_1         = $request['dis1'];
        $dt->qty            = $newqty;
        $dt->harga          = $hg;
        $dt->update();
        
        echo json_encode(['msg'=>'success']);
        
    }
    
    public function simpanEditHarga(Request $request, $id){

        $dt = InvoiceDetail::find($id);
        $inv = Invoice::find($dt->inv_id);
        
        $hg  = $request['harga'];

        $dt->disc_1         = $request['dis1'];
        $dt->harga          = $hg;
        $dt->update();
        
        echo json_encode(['msg'=>'success']);
        
    }    
    
    public function posting(Request $request){
    
        $inv = Invoice::find($request['idinv']);
        $dt  = InvoiceDetail::where('inv_id', $inv->id)
                                ->where('is_posted', 0)
                                ->get();
        
    // return json_encode(['msg'=>'success']);   
        
        foreach($dt as $list){
            
            $this->updStock($list->product_id, $list->qty * $list->isi, $inv->gudang_id, $inv->inv_tgl);

            /* update status posting */
            $pp = InvoiceDetail::find($list->id);
            $pp->is_posted = 1;
            $pp->update();
            
        }
        
        $inv->inv_posted=1;
        $inv->update();

	// insert logs
			$usrnm	= Auth::user()->username;

			$title		= 'Posting Invoice ';
			$content	= 'Invoice No.'.$inv->inv_no.' berhasil diposting oleh '.$usrnm;
			$userid	    = Auth::user()->id;

        User_logs::UserLogs($title, $content, $userid);
        
        echo json_encode(['msg'=>'success']);
    }


    
    public function printPO($id){
        
        $mpo = MSPo::find($id);
        $gdg = Gudang::find($mpo->gudang_id);
        $dt  = DTPo::where('po_id', $id)
                        ->where('qty', '!=',0)
                        ->get();  
                            
        $sup = Supplier::with('get_city')
                            ->where('id',$mpo->supp_id)
                            ->first();                    

        $sub=0;
        foreach($dt as $list){
            $sub += ($list->qty * $list->harga)-($list->qty * $list->harga * $list->disc/100);
        }
        $no=1;
        $dis = $sub * $mpo->po_disc /100;
        $ppn = ($sub - $dis) * $mpo->po_ppn/100;
        $ttl = round($sub - $dis + $ppn);
        
        return view('purchase.faktur', compact('mpo','dt','sub', 'dis','ppn','ttl','sup','gdg','no'));
    }
    
/* print faktur printer dotmatrix */
    public function printFaktur_matrix($id){
        
        $inv = Invoice::find($id);
        $dt  = InvoiceDetail::with('get_product')
                                ->where('inv_id', $id)
                                ->get();  
                            
        $sup = Supplier::find($inv->supp_id); 
        
        $pin    = 0;
        $on_ms  = 120;
        $off_ms = 240;
        $feed   = "\x0c";
        
        $lebarkolom = 80;
        $bold1      = Chr(27) . Chr(69);
        $bold0      = Chr(27) . Chr(70);
        $initialized= chr(27) . chr(64);
        $condensed1 = chr(15);
        $condensed0 = chr(18);

        $setLeft    = chr(27) . "a" . chr(0);
        $setCenter  = chr(27) . "a" . chr(1);
        $setRight   = chr(27) . "a" . chr(2); 
    
        $fontNormal	= chr(27) . "!" . chr(0);
        $fontKecil	= chr(27) . "!" . chr(1);
        $fontTebal	= chr(27) . "!" . chr(8);
        $fontBesar	= chr(27) . "!" . chr(16);
        $fontLebar	= chr(27) . "!" . chr(32);
        $fontUline	= chr(27) . "!" . chr(128);
        $fontSans   = chr(27) . "k" . chr(1);

        $grs=PrinterController::replicate('-',$lebarkolom);

        $Data  = $initialized;
        $Data .= $condensed0;

        $Data .= $fontTebal.PrinterController::center("INVOICE PEMBELIAN", $lebarkolom)."\n";
        $Data .= PrinterController::strKarakter($sup->sup_nama,50).PrinterController::rataKanan(tanggal_indonesia($inv->inv_tgl, false),30)."\n";
        $Data .= PrinterController::strKarakter("Faktur  : ".$inv->inv_no,80)."\n";
        $Data .= PrinterController::strKarakter("J.Tempo : ".tanggal_indonesia($inv->inv_jt, false),50)."\n";
        $Data .= PrinterController::strKarakter("Disc.   : ".PrinterController::strAngka($inv->inv_disc,3)."%   PPN : ".PrinterController::strAngka($inv->inv_ppn,3)."%", 80)."\n";

        $Data .= $condensed0;        
        $Data .= $grs."\n";
        //$Data .= $fontKecil.$fontTebal;
        
        /*        0        1         2         3         4         5         6         7         8         9*/
        /*        123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789.   */
        /*        1234 123456789.123456789.123456789.123456789. 9999XXX 9,999,999  99% 99,999,999*/
        $Data .= "KODE  Nama Barang                              --QTY--     Harga  Disc    Jumlah\n";
        $Data .= $grs."\n";
        
        $no = 0;
        $ttl = 0;
        
        foreach($dt as $dtl){
            $no++;
            $jlh = ($dtl->qty * $dtl->harga)-($dtl->qty*$dtl->harga*$dtl->disc_1/100); 
            $ttl += $jlh;
            
            $kd = $condensed1.PrinterController::strKarakter($dtl->get_product->kode_brg,8).$condensed0;
            $nm = PrinterController::strKarakter(substr($dtl->product_name,0,40),40);
            $qq = PrinterController::rataKanan(format_uang($dtl->qty),4).substr($dtl->satuan,0,3);
            $hg = PrinterController::strAngka($dtl->harga,9);
            
            if($dtl->disc_1>0){
                $ds = PrinterController::strAngka($dtl->disc_1,3)."%";
            }else{
                $ds = "  --";
            }
            
            $jl = PrinterController::strAngka($jlh,10);
            
            $Data .=$kd." ".$nm." ".$qq." ".$hg." ".$ds." ".$jl."\n";
        }
        
        $Data .= $grs."\n";
        $Data .= PrinterController::space(55)."Sub Total   ".PrinterController::strAngka($ttl,13)."\n";
        
        $dis =0;
        $ppn =0;
        
        if($inv->inv_disc>0){
            $dis = round($ttl * $inv->inv_disc/100);
            $Data .= PrinterController::space(55)."Disc ".PrinterController::strAngka($inv->inv_disc,3)."%   ".PrinterController::strAngka($dis,13)."\n";
        }
        
        $ttl -= $dis;

        if($inv->inv_ppn>0){
            $ppn = round($ttl * $inv->inv_ppn/100);
            $Data .= PrinterController::space(55)."PPN         ".PrinterController::strAngka($ppn,13)."\n";
        }     
        
        $Data .= PrinterController::space(55)."# TOTAL #   ".PrinterController::strAngka($ppn+$ttl,13)."\n";
        $Data .= $condensed1.terbilang(round($ttl+$ppn))." rupiah# \n\n";
        $Data .= $condensed0.PrinterController::space(10).PrinterController::strKarakter('Penerima', 40).'Mengetahui'."\n\n\n";
        //$Data .= PrinterController::space(10).PrinterController::strKarakter('Cap & Nama Jelas',40).'Admin'."\n";
        
        $Data .= $feed;

        $dt = "intent:base64," . base64_encode($Data) . "#Intent;scheme=rawbt;package=ru.a402d.rawbtprinter;end;";
        $output = ["data"=>$dt];

        return response()->json($output);

    }
        
    
/*------------------------------------------------------*/
    function history_header()
    {

		$inv = Invoice::with('get_supplier','get_gudang')
                            ->where('inv_batal',1)
		                   	->orWhere('inv_posted',1)
							->orderby('inv_no','DESC')
							->get();
		
		$data = [];
		
		foreach($inv as $list)
		{
		    
		    if($list->inv_lunas==1){ $lns='<label class="label-success">&nbsp;&#10003&nbsp;</label>'; }else{ $lns='<label class="label-danger">&nbsp;x&nbsp;</label>'; }
		    
			$row = [];
            
            $row[] = $list->no_urut;
			$row[] = $list->inv_no;
			$row[] = $list->get_gudang->kode;
			$row[] = tanggal_indonesia($list->inv_tgl, false);
			$row[] = tanggal_indonesia($list->inv_jt, false);
			$row[] = $list->get_supplier->sup_nama;
			$row[] = $list->inv_ppn;
			$row[] = $list->inv_disc;
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_netto).'</div>';
			$row[] = $lns;
	        $row[] = '<div class="btn-btn">
				        <a onclick="showDetail('.$list->id.')" class="btn btn-success btn-sm"><i class="fa fa-eye"></i></a>
				    </div>';	
			
		    $data[] = $row;
		}

		return response()->json(["data"=>$data]);								
			
    }
    


/////////////////////////////////////////////////////////////////////////


/* reprint inv */
    public function reprint($id)
    {
		session(['idinv'=>$id]);
		return Redirect::route('invoicedetail.reprint');				//cetak po
    }

	
}
