<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use App\Pegawai;
use App\Jabatan;
use App\User;
use App\User_logs;
use DataTables;


class PegawaiController extends Controller
{
   public function index()
   {
        $jbt = Jabatan::orderBy('jabatan')->get();

		return view('pegawai.index', compact('jbt')); 
   }


   public function listData() {
     
    $peg = Pegawai::with('get_jabatan')
                    ->orderBy('nip','ASC')
					->get();
   
     $data = [];
     foreach($peg as $list){
       
       if($list->is_gender=='0'){ $sex='W'; }else{ $sex='P'; }
       
       $row = [];
       $row[] = $list->nip; 
       $row[] = $list->nama;
       $row[] = $list->get_jabatan->jabatan;
       $row[] = $sex;
       $row[] = $list->alamat;
       $row[] = $list->nohp;
       $row[] = tanggal_indonesia($list->tgl_kerja, false);

       $row[] = '<div class="btn-btn">
                    <a onclick="editForm('.$list->id.')" class="btn btn-flat btn-xs"><i class="fa fa-pencil"></i></a>
                    <a onclick="kasbon('.$list->id.')" class="btn btn-flat btn-xs"><i class="fa fa-credit-card-alt"></i></a>
               </div>';
       $data[] = $row;
     }

     return response()->json(['data'=>$data]);
	 
   }

   public function store(Request $request)
   {

        $peg = new Pegawai;
      
        $peg->nip       = $request['nip'];
	    $peg->nama      = strtoupper($request['nama']);
        $peg->alamat    = ucwords(strtolower($request['alamat']));
        $peg->jabatan_id= $request['jbt'];
        $peg->is_gender = $request['sex'];
        $peg->nohp	    = $request['nohp'];
        $peg->noacct    = $request['norek'];
        $peg->bank      = $request['bank'];
        $peg->tgl_kerja = $request['tglkerja'];
        $peg->deskripsi = $request['ket'];
	    $peg->user_id	= Auth::user()->id;
        $peg->save();

      // insert logs
        $usrnm	= Auth::user()->username;
        
        $title		= 'New Pegawai';
        $content	= 'Pegawai '.$request['nama'].' berhasil ditambah oleh '.$usrnm;
        $userid	    = Auth::user()->id;
        
        User_logs::UserLogs($title, $content, $userid);
        
        echo json_encode(array('msg'=>'success'));
   }
   
    public function show($id){
       $dt = Pegawai::find($id);
       echo json_encode($dt);
    }

    public function edit($id)
    {
        $dt = Pegawai::find($id);
        echo json_encode($dt);
    }

    function tampilpegawai($id){
        
        $peg = Pegawai::find($id);
        $jbt = Jabatan::find($peg->jabatan_id);
        
        $dt=['id'=>$peg->id, 'nama'=>$peg->nama, 'nip'=>$peg->nip, 'tgl_kerja'=>$peg->tgl_kerja, 'jabatan'=>$jbt->jabatan];
        
        echo json_encode($dt);
    }

   public function update(Request $request, $id)
   {
        $peg = Pegawai::find($id);
      
        $peg->nip       = $request['nip'];
	    $peg->nama      = strtoupper($request['nama']);
        $peg->alamat    = ucwords(strtolower($request['alamat']));
        $peg->jabatan_id= $request['jbt'];
        $peg->is_gender = $request['sex'];
        $peg->nohp	    = $request['nohp'];
        $peg->noacct    = $request['norek'];
        $peg->bank      = $request['bank'];
        $peg->tgl_kerja = $request['tglkerja'];
        $peg->deskripsi = $request['ket'];
	    $peg->user_id	= Auth::user()->id;
        $peg->update();

      // insert logs
        $usrnm	= Auth::user()->username;
        
        $title		= 'Edit Pegawai';
        $content	= 'Pegawai '.$request['nama'].' berhasil diedit oleh '.$usrnm;
        $userid	    = Auth::user()->id;
        
        User_logs::UserLogs($title, $content, $userid);
        
        echo json_encode(array('msg'=>'success'));
   }


}
