<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Invoice;
use App\Supplier;
use App\Pelunasan;
use App\Gudang;
use App\User_logs;
use DataTables;
use DB;
use Auth;
Use Redirect;

class PelunasanController extends Controller
{

	public function index()
	{	
	    //$sup = Supplier::orderBy('sup_nama')
	    //                    ->get();
	    $gdg = Gudang::orderBy('nama')
	                        ->get();
	                        
		return view('pelunasan.index', compact('gdg'));
	}
	
	function tampilData($gdg, $tgl1, $tgl2, $tp){
	    
	    /* tipe==1 hanya yg belum lunas, tipe=2 all */
	    //$tipe="2";
	    
	    if($tp=="1"){ $lns='0'; }else{ $lns='1'; }
	    
	    if($gdg=="0"){
            $dd = DB::table('ms_invoice as A')
	                ->select('A.id','A.inv_lunas','A.inv_tgl','A.inv_jt','A.inv_no','A.supp_id', 'A.inv_netto','B.sup_nama','C.lunas_no','C.lunas_tgl','A.gudang_id')
	                ->leftjoin('ms_supp as B', function($join){
	                    $join->on('A.supp_id', '=', 'B.id');
	                })
	                ->leftjoin('ms_pelunasan as C', function($join){
	                    $join->on('C.inv_id','=', 'A.id');
	                })
	                ->where('A.inv_posted',1)
	                ->where('A.inv_batal',0)
	                ->where('A.inv_lunas', $lns)
	                ->whereBetween('A.inv_tgl', [$tgl1, $tgl2])
	                ->get();

	    }else{
            $dd = DB::table('ms_invoice as A')
	                ->select('A.id','A.inv_lunas','A.inv_tgl','A.inv_jt','A.inv_no','A.supp_id', 'A.inv_netto','B.sup_nama','C.lunas_no','C.lunas_tgl','A.gudang_id')
	                ->leftjoin('ms_supp as B', function($join){
	                    $join->on('A.supp_id', '=', 'B.id');
	                })
	                ->leftjoin('ms_pelunasan as C', function($join){
	                    $join->on('C.inv_id','=', 'A.id');
	                })
	                ->where('A.inv_posted',1)
	                ->where('A.inv_batal',0)
	                ->where('A.gudang_id', $gdg)
	                ->where('A.inv_lunas', $lns)
	                ->whereBetween('A.inv_tgl', [$tgl1, $tgl2])
	                ->get();
        }
	                
	    $data=[];
	    foreach($dd as $list){
	        
            if($list->inv_lunas==1){ $sts='&nbsp;&nbsp;<label class="label-success">&nbsp;&nbsp;</label>'; }else{ $sts='&nbsp;&nbsp;<label class="label-danger">&nbsp;&nbsp;</label>'; }
			$row = [];

			$row[] = tanggal_indonesia($list->inv_tgl, false);
			$row[] = $list->inv_no;
			$row[] = $list->sup_nama;
			$row[] = tanggal_indonesia($list->inv_jt, false);
			$row[] = '<div class="text-right">'.format_uang($list->inv_netto).'&nbsp;&nbsp;&nbsp;</div>';
            $row[] = $sts;
            $row[] = $list->lunas_no;
            $row[] = Gudang::get_gudang($list->gudang_id)->nama;
            if($list->inv_lunas==1){
                $row[]=
    	              '<div class="btn-btn">
                        <a onclick="infopelunasan('.$list->id.')" class="btn btn-info btn-xs"><i class="fa fa-info"></i></a>
                    </div>';
            }else{
            $row[]=
	              '<div class="btn-btn">
                        <a onclick="pelunasan('.$list->id.')" class="btn btn-info btn-xs"><i class="fa fa-money"></i></a>
                    </div>';
            }
            
            $data[]=$row;
	    }
	    
	    return response()->json(["data"=>$data]);
	    
	}
	

    
    public function tampilHeader($id){
        
        $dt = Invoice::find($id);
        $sup = Supplier::find($dt->supp_id);

        echo json_encode(array_merge(json_decode($sup, true),json_decode($dt, true) ));
    }    
    
/* simpan pelunasan */    
    public function store(Request $request){
        
        $inv = Invoice::find($request['id']);
        
        $ttl = $inv->inv_netto;

        $byr = $request['ttl'];
        $pot = $request['pot'];
        
        if(empty($byr)){ return json_encode(["msg"=>"error-1"]); }
        if(empty($pot)){ $pot=0; }
        
        if($ttl-$pot != $byr){ return json_encode(["msg"=>"error-2"]); }
        
            $no = $this->cekNoLunas();
            
            $dt = new Pelunasan;
            
            $dt->inv_id     = $inv->id;
            $dt->lunas_no   = $no;
            $dt->lunas_tgl  = $request['tgltrx'];
            $dt->inv_total  = $ttl;
            $dt->potongan   = $pot;
            $dt->nominal    = $byr;
            $dt->deskripsi  = $request['ket'];
            $dt->lunas_type = $request['tp'];
            $dt->user_id    = Auth::user()->id;
            $dt->save();
            
            $cek = Pelunasan::where('lunas_no', $no)
                                ->first();
        
            $inv->inv_lunas = 1;
            $inv->lunas_id  = $cek->id;
            $inv->update();


	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= "Pelunasan Invoice";
			$userlog->content	= "Pelunasan ".$inv->no_urut.' inv.no '.$inv->inv_no.'  berhasil dicreate oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
        
    }
    
    public static function cekNoLunas(){
    	/* cek no terakhir */
		$nolns	= '';
		$tahun	= date('y');
		$bulan  = date('m');
		$nomor	="LNS/".$tahun.$bulan."/";		/* INV/2205/0001*/
			
		$ada_no	= DB::table('ms_pelunasan')
						->select(DB::raw('SUBSTR(MAX(lunas_no),10,4) as last_no'))
						->where('lunas_no', 'LIKE', "$nomor%" )
						->first();
			
		if (!empty($ada_no))
		{
			$no	= $ada_no->last_no + 1;
				
			$nomorbaru 	= sprintf("%04s", $no);		//format: IN/202101/0001
			$nolns = $nomor.$nomorbaru;
			
		} else {
			$nomorbaru = "0001";
			$nolns = $nomor.$nomorbaru;
		}
		
		return $nolns;
    }			

    public function infoPelunasan($id){
        
        $inv = Invoice::find($id);
        $lns = Pelunasan::find($inv->lunas_id);
        $sup = Supplier::find($inv->supp_id);

        $byr='';
        switch($lns->lunas_type){
            case "1": $byr="TRANSFER"; break;
            case "2": $byr="CASH"; break;
            case "3": $byr="CEK/GIRO";break;
        }
    
        
        $data=[];
        
        $row=[];
        $row[]="NO. PELUNASAN ";
        $row[]=$lns->lunas_no;
        $data[]=$row;
        
        $row=[];
        $row[]="TGL. PELUNASAN ";
        $row[]= tanggal_indonesia($lns->lunas_tgl, false);
        $data[]=$row;

        $row=[];
        $row[]="NO.INVOICE";
        $row[]=$inv->inv_no;
        $data[]=$row;
        
        $row=[];
        $row[]="SUPPLIER";
        $row[]=$sup->sup_nama;
        $data[]=$row;
        
        $row=[];
        $row[]="TOTAL FAKTUR";
        $row[]=format_uang($inv->inv_netto);
        $data[]=$row;
        
        $row=[];
        $row[]="POTONGAN";
        $row[]=format_uang($lns->potongan);
        $data[]=$row;

        $row=[];
        $row[]="TOTAL BAYAR";
        $row[]=format_uang($lns->nominal);
        $data[]=$row;

        $row=[];
        $row[]="PEMBAYARAN ";
        $row[]= $byr;
        $data[]=$row;

        $row=[];
        $row[]="KETERANGAN PELUNASAN";
        $row[]=$lns->deskripsi;
        $data[]=$row;

        $row=[];
        $row[]="KETERANGAN INVOICE";
        $row[]=$inv->deskripsi;
        $data[]=$row;

        $row=[];
        $row[]='';
        $row[]='';
        $data[]=$row;
        
        return response()->json(["data"=>$data]);

    }	    
    


    function index_history(){
        
        $gdg = Gudang::all();
        
        return view('pelunasan.history', compact('gdg'));
    }

	function history($gdg, $tgl1, $tgl2){
	    
            $dd = DB::table('ms_invoice as A')
	                ->select('A.id','A.inv_lunas','A.inv_tgl','A.inv_jt','A.inv_no','A.supp_id', 'A.inv_netto','B.sup_nama','C.lunas_no','C.lunas_tgl','A.gudang_id')
	                ->leftjoin('ms_supp as B', function($join){
	                    $join->on('A.supp_id', '=', 'B.id');
	                })
	                ->leftjoin('ms_pelunasan as C', function($join){
	                    $join->on('C.inv_id','=', 'A.id');
	                })
	                ->where('A.inv_posted',1)
	                ->where('A.inv_batal',0)
	                ->where('A.inv_lunas', 1)
	                ->where('A.gudang_id', $gdg)
	                ->whereBetween('C.lunas_tgl', [$tgl1, $tgl2])
	                ->get();


	    $data=[];
	    $sts='LNS';
	    foreach($dd as $list){
	        
			$row = [];

			$row[] = tanggal_indonesia($list->inv_tgl, false);
			$row[] = $list->inv_no;
			$row[] = $list->sup_nama;
			$row[] = tanggal_indonesia($list->inv_jt, false);
			$row[] = '<div class="text-right">'.format_uang($list->inv_netto).'&nbsp;&nbsp;&nbsp;</div>';
            $row[] = $sts;
            $row[] = $list->lunas_no;
            $row[] = Gudang::get_gudang($list->gudang_id)->nama;
            $row[]= '<div class="btn-btn">
                        <a onclick="infopelunasan('.$list->id.')" class="btn btn-info btn-xs"><i class="fa fa-info"></i></a>
                    </div>';
 
            $data[]=$row;
	    }
	    
	    return response()->json(["data"=>$data]);
	    
	}
	

	
}
