<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Supplier;
use App\Invoice;
use App\DTBayar;
use App\User_logs;
use DataTables;
use DB;
use Auth;
Use Redirect;

class PembayaranController extends Controller
{

	public function index()
	{		
	    $sup = Supplier::all();
		return view('pembayaran.index', compact('sup'));
	}
	
	function tampilData($sup){

	    $dd = Invoice::with('get_supplier')
	                ->select('ms_invoice.id','ms_invoice.inv_lunas','ms_invoice.inv_tgl','ms_invoice.inv_jt','ms_invoice.inv_no',
	                    'ms_invoice.supp_id', 'ms_invoice.inv_netto','dt_bayar.retur','dt_bayar.potongan','dt_bayar.nominal','dt_bayar.keterangan')
	                ->leftjoin('dt_bayar', function($join){
	                    $join->on('ms_invoice.id', '=', 'dt_bayar.inv_id');
	                })
	                ->where('ms_invoice.inv_posted',1)
	                ->where('ms_invoice.inv_batal',0)
	                ->where('ms_invoice.inv_lunas', 0)
	                ->where('ms_invoice.supp_id', $sup)
	                ->get();

	    $data=[];
	    foreach($dd as $list){
	        
	        $row=[];
			$row[] = tanggal_indonesia($list->inv_tgl, false);
			$row[] = $list->inv_no;
			$row[] = $list->get_supplier->sup_nama;
			$row[] = tanggal_indonesia($list->inv_jt, false);
			$row[] = '<div class="text-right">'.format_uang($list->inv_netto).'&nbsp;&nbsp;&nbsp;</div>';
			//$row[] = '<div class="text-right">'.format_uang($list->potongan+$list->retur).'&nbsp;&nbsp;&nbsp;</div>';
            //$row[] = '<div class="text-right">'.format_uang($list->nominal).'&nbsp;&nbsp;&nbsp;</div>';
            //$row[] = '<textarea rows="2" cols="35">'.$list->keterangan.'</textarea>';	 
            $row[]='<div class="btn-group">
                        <a onclick="pelunasan('.$list->id.')" class="btn btn-success btn-sm"><i class="fa fa-money"></i></a>
                    </div>';
            
            
            $data[]=$row;
	    }
	    
	    return response()->json(["data"=>$data]);
	    
	}
	

    
    public function tampilBayar($id){
        $dt = Invoice::find($id);
        $sup = Supplier::find($dt->supp_id);
        $lns = DTBayar::where('inv_id', $id)
                        ->first();
        
        if(empty($lns)){
            echo json_encode(array_merge(json_decode($sup, true),json_decode($dt, true) ));
        }else{                
            echo json_encode(array_merge(json_decode($sup, true),json_decode($dt, true),json_decode($lns, true) ));
        }
    }    
    
/* simpan pelunasan */    
    public function store(Request $request){
        
        $ftr = Invoice::find($request['id']);
        
        $ttl = $ftr->inv_netto;
        
        $byr = $request['ttl'];
        $rtr = $request['rtr'];
        $pot = $request['pot'];
        
        if(empty($byr)){ return json_encode(["msg"=>"error-1"]); }
        if(empty($rtr)){ $rtr=0; }
        if(empty($pot)){ $pot=0; }
        
        if($ttl-$rtr-$pot != $byr){ return json_encode(["msg"=>"error-2"]); }
            
            $dt = new DTBayar;
            $dt->inv_id     = $ftr->id;
            $dt->tanggal    = $request['tgltrx'];
            $dt->inv_netto  = $ttl;
            $dt->retur      = $rtr;
            $dt->potongan   = $pot;
            $dt->nominal    = $byr;
            $dt->keterangan = $request['ket'];
            $dt->user_id    = Auth::user()->id;
            $dt->save();
        
            $ftr->inv_lunas = 1;
            $ftr->update();



	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= "Pelunasan Invoice Pembelian";
			$userlog->content	= "Pelunasan ".$ftr->inv_no.'  berhasil dicreate oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(array('msg'=>'success'));
        
    }
    

    function index_history(){
        return view('pembayaran.history');
    }

	function history(){

	    $dd = Invoice::with('get_supplier')
	                ->select('ms_invoice.id','ms_invoice.inv_lunas','ms_invoice.inv_tgl','ms_invoice.inv_jt','ms_invoice.inv_no',
	                    'ms_invoice.supp_id', 'ms_invoice.inv_netto','dt_bayar.retur','dt_bayar.potongan','dt_bayar.nominal','dt_bayar.keterangan')
	                ->leftjoin('dt_bayar', function($join){
	                    $join->on('ms_invoice.id', '=', 'dt_bayar.inv_id');
	                })
	                ->where('ms_invoice.inv_lunas',1)
	                ->get();

	    $data=[];
	    foreach($dd as $list){
	        
	        $row=[];
			$row[] = tanggal_indonesia($list->inv_tgl, false);
			$row[] = $list->inv_no;
			$row[] = $list->get_supplier->sup_nama;
			$row[] = tanggal_indonesia($list->inv_jt, false);
			$row[] = '<div class="text-right">'.format_uang($list->inv_netto).'&nbsp;&nbsp;&nbsp;</div>';
			$row[] = '<div class="text-right">'.format_uang($list->potongan+$list->retur).'&nbsp;&nbsp;&nbsp;</div>';
            $row[] = '<div class="text-right">'.format_uang($list->nominal).'&nbsp;&nbsp;&nbsp;</div>';
            $row[] = '<textarea rows="2" cols="35">'.$list->keterangan.'</textarea>';	 
            //$row[]='<div class="btn-group">
            //            <a onclick="pelunasan('.$list->id.')" class="btn btn-success btn-sm"><i class="fa fa-money"></i></a>
            //        </div>';
            
            
            $data[]=$row;
	    }
	    
	    return response()->json(["data"=>$data]);
	    
	}
	
	

	
}
