<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\ProductSub;
use App\Category;

use App\Supplier;
use App\User;
use App\User_logs;
use DataTables;
use DB;
use Auth;
use Session;


use App\Imports\ProductImport;
use Illuminate\Support\Facades\Input;
use Excel;


class ProductController extends Controller
{
	
    public function index()
    {

		$category 	= Category::all()->sortBy('cat_name');  
		$sup    	= Supplier::all()->sortBy('sup_nama');
		
		return view('product.index', compact('category','sup'));
    }	

    function getdata()
    {
     	$dt = Product::with('get_category')
     	                    ->orderBy('cat_id','ASC')
     	                    ->orderBy('nama_brg', 'ASC')
     	                    ->get();

	    $data=[];
	    foreach($dt as $list){
	        
	        if($list->is_stock==1){ $stk="Ya"; }else{ $stk="No";}
	        
	        $row=[];
	        
	        $row[]= $list->nama_brg;
	        $row[]= $list->get_category->cat_name;
	        $row[]= $list->satuan.'/'.$list->isi;
            $row[]= '<div class="text-right">'.format_uang($list->harga).'</div>';
	        $row[]= $list->deskripsi;
	        $row[]= $stk;
	        $row[]= '<div class="btn-group">
                        <a onclick="editForm('.$list->id.')" class="btn btn-sm btn-flat"><i class="fa fa-pencil"></i></a>
                    </div>';
	        
	        $data[]=$row;
	    }
	
	    return response()->json(["data"=>$data]);
	
    }
	
    function pilihdata()
    {
     	$Produk = Product::leftJoin('ms_category', 'ms_category.id_cat', '=', 'ms_product.cat_id');
	 
		return Datatables::of($Produk)->make(true);
    }	

    public function store(Request $request)
    {
		if($request['cat']==""){ return json_encode(["msg"=>"error"]); }

    	$produk = new Product;

		$produk->nama_brg    = ucwords(strtolower($request['nama']));
		$produk->cat_id      = $request['cat'];
		$produk->harga       = $request['harga'];
		$produk->deskripsi	 = $request['desk'];
		$produk->satuan      = strtoupper($request['stn']);
		$produk->isi         = $request['isi'];
		$produk->is_active	 = 1;
		$produk->is_stock    = $request['stock'];
		$produk->user_id	 = Auth::user()->id;
	 
		$produk->save();

	// insert logs
		$usrnm	= Auth::user()->username;
		
        $title  = 'New Master Product';
        $content= 'Product '.$request['nama'].' berhasil ditambahkan oleh '.$usrnm;
        $userid = Auth::user()->id;
        
        User_logs::UserLogs($title, $content, $userid);
        
		echo json_encode(array('msg'=>'success'));
        
    }

    public function edit($id)
    {
      $produk = Product::find($id);
      echo json_encode($produk);
    }

   public function show($id)
   {
	    $produk 	= Product::where('id',$id)->get();
		$data   = array();	
		
		foreach ($produk as $detail)
		{
	
			$category	= Category::find($detail->cat_id);
			$supplier	= Supplier::find($detail->supplier);
						
	
			$usernm	= User::find($detail->user_id);
			
			if($detail->is_mixed==1){ $oplos = '<div class="label label-success">Ya</div>'; }
			                        else{ $oplos = '<div class="label label-danger">Tidak</div>'; }
		
     		$row    = array();
			$row[]  = "Nama Barang";
			$row[]	= $detail->nama_brg.' - '.$detail->kode_brg;
			$data[] = $row;
			
			$row    = array();
			$row[]  = "Category";
			$row[]	= $category->cat_name;
 			$data[] = $row;

			$row    = array();
			$row[]  = "Deskripsi";
			$row[]	= $detail->deskripsi;
 			$data[] = $row;			
 			
			$row	= array();
			$row[]	= "Last Updates";
			$row[]	= $detail->updated_at."&nbsp;&nbsp;&nbsp;by.&nbsp;".$usernm->username;
			$data[]	= $row;
		}

        $output = array("data" => $data);
        return response()->json($output);
	 
   }

    public function update(Request $request, $id)
    {
		
		$produk = Product::find($id);

		$produk->nama_brg    = ucwords(strtolower($request['nama']));
		$produk->cat_id      = $request['cat'];
		$produk->deskripsi   = $request['desk'];
		$produk->harga       = $request['harga'];
		$produk->is_stock    = $request['stock'];
		$produk->satuan      = strtoupper($request['stn']);
		$produk->isi         = $request['isi'];
		
		$produk->user_id	 = Auth::user()->id; 
 
		$produk->update();
		
// insert logs
		$usrnm	= Auth::user()->username;

        $title  = 'Edit Master Product';
        $content= 'Product '.$request['nama'].' berhasil diedit oleh '.$usrnm;
        $userid = Auth::user()->id;
        
        User_logs::UserLogs($title, $content, $userid);
 		

        echo json_encode(array('msg'=>'success'));
    }

    public function uploadImg($id){
    	$idproduct = $id;
    	return view('product.upload', compact('idproduct'));
    }

	public function removeImage($id)
	{
		$pp = Product::find($id);
		$file_img = $pp->image;
		
		$pp->image = null;
		$pp->update();
		
		//hapus file gambar
		unlink($file_img);
		
		echo json_encode(array('msg'=>'success'));
		
	}   
	
	public function index_product(){
	    return view('order.index_product');
	}
	
	public function master_Product(){
		$prd = Product::where('is_active',1)
		                ->orderBy('nama_brg')
		                ->get();
		
		$data = [];
		
		foreach($prd as $list){
			$row = [];
			
			$row[] = '<div class="text-left" style="width:220px;">'.$list->nama_brg.'</div>' ;
            $row[] = '<div class="text-right" style="width:100px;">'.format_uang($list->harga_retail).'</div>';
  		    //$row[] = '<a onclick="tampilImage('.$list->id.')" class="btn btn-flat btn-sm" style="width:auto; height:auto; margin-right:-25px;margin-bottom:-25px; padding:1px -10px;"><i class="fa fa-picture-o fa-2x"></i></a>';
  		    $row[] = '<a onclick="tampilImage('.$list->id.')" class="btn btn-flat btn-sm"><i class="fa fa-picture-o fa-2x"></i></a>';

			$data[] = $row;
        }

        $output = array("data" => $data);
        return response()->json($output);
	}	  

	public function masterProduct(){
		$prd = Product::where('is_active',1)
		                ->orderBy('nama_brg')
		                ->get();
		
		$data = [];
		
		foreach($prd as $list){
			$row = [];
			
			if($list->image==null)
            {
                $row[]= '<div class="card" style="width:auto;height:auto; margin-bottom:5px;margin-top:0px;">
                        <div class="card-block">
                            <div class="text-right" style="margin-top:12px; margin-right:10px; margin-bottom:12px;">
                                <h5>'.$list->nama_brg.'</h5>
                                <h3>'.$list->harga_retail.'</h3>
                            </div>
                        </div>
                    </div>';
            }else{
                $row[]= '<div class="card" style="width:auto;height:auto; margin-bottom:5px;margin-top:0px;">
                        <div class="card-block">
                            <img src='.DIR_APP.$list->image.' class="img-thumbnail" style="width:100px; height:100px; padding:1px 1px;">
                            <div class="text-right" style="margin-top:-80px; margin-right:10px;margin-bottom:5px; padding-bottom:10px;">
                                <h5>'.$list->nama_brg.'</h5>
                                <h3>'.$list->harga_retail.'</h3>
                            </div>
                        </div>
                    </div>';
            }
            
			$data[] = $row;
        }

        $output = array("data" => $data);
        return response()->json($output);
	}	 
	
    public function import_data(){
        return view('product.upload');
    }	

    public function importProduct(Request $request) {
        
        if($request->file=="")
        	{ Session::flash('error','File harus dipilih ! ');
    		  return back();
		    }
        

        Excel::import(new ProductImport, request()->file('file'));  
            
    	Session::flash('sukses','Data  '.$name.' Berhasil Diimport ! ');
    	return back();
        
    }

    public function printMaster(){
        
        $dt = Product::orderby('nama_brg')
                            ->get();

        $no=1;                    
                    
        return view('product.masterlist', compact('dt','no'));
    }
    


}
