<?php

namespace App\Http\Controllers;

use Mike42\Escpos\Printer; 
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\RawbtPrintConnector;
use Mike42\Escpos\CapabilityProfile;

use Illuminate\Http\Request;
use DataTables;
use Auth;
use DB;
use Session;
use Redirect;

use App\User;
use App\City;
use App\User_logs;
use App\Setting;
use App\ProjectRumah;
use App\MSRumah;



class ProjectController extends Controller
{
    
    public function index(){

        return view('project.index');
    }
    
    public function dataproject(){
    
        $pj = ProjectRumah::all();
                        
        $data=[];
        foreach($pj as $dt){
            
            $row=[];
            $row[] = $dt->project_name;
            $row[] = $dt->initial;
            $row[] = $dt->address."<br>".$dt->kota;
            $row[] = $dt->deskripsi;
            $row[] = '<div class="btn-group">
                        <a onclick="editproject('.$dt->id.')" class="btn btn-sm btn-flat"><i class="fa fa-pencil"></i></a>
                        <a onclick="listrumah('.$dt->id.')" class="btn btn-sm btn-flat"><i class="fa fa-list"></i></a>
                      </div>';

            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
        
    }
    
    public function store(Request $request){
        
        $nm = ucwords(strtolower($request['prj']));
        
        $prj = new ProjectRumah;
        
        $prj->project_name  = $nm;
        $prj->initial       = strtoupper($request['ini']);
        $prj->address       = ucwords(strtolower($request['alm']));
        $prj->kota          = ucwords(strtolower($request['kota']));
        $prj->deskripsi     = $request['ket'];
        $prj->save();
        
	// insert logs
		$usrnm	= Auth::user()->username;
		
		$userlog = New User_logs;
		$userlog->title		= 'New Project';
		$userlog->content	= 'Project '.$nm.' berhasil ditambahkan oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();
        
        echo json_encode(["msg"=>"success"]);
    }
    

    public function edit($id){
        $dt = ProjectRumah::find($id);

        echo json_encode($dt);

    }

    public function show($id){
        $dt = ProjectRumah::find($id);
        echo json_encode($dt);
    }
    
    public function update(Request $request, $id){

        $prj = ProjectRumah::find($id);
        $prj->initial       = strtoupper($request['ini']);
        $prj->address       = ucwords(strtolower($request['alm']));
        $prj->kota          = ucwords(strtolower($request['kota']));
        $prj->deskripsi     = $request['ket'];
  
        $prj->update();
        

	// insert logs
		$usrnm	= Auth::user()->username;
		
		$userlog = New User_logs;
		$userlog->title		= 'Edit Project';
		$userlog->content	= 'Project '.$prj->project_name.' berhasil diedit oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
		$userlog->save();

		echo json_encode(['msg'=>'success']);        
        
    }
 

}
