<?php

/*---------------------------------

project : scm
ReportController
last modif : 2021-12-19
--------------------------------*/

namespace App\Http\Controllers;

use Mike42\Escpos\Printer; 
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\RawbtPrintConnector;
use Mike42\Escpos\CapabilityProfile;

use Illuminate\Http\Request;
use DataTables;
use Auth;
use DB;
use Session;
use Redirect;

use App\User;
use App\City;
use App\User_logs;
use App\Setting;
use App\ProjectRumah;
use App\Gudang;
use App\MSRumah;
use App\Transaksi;
use App\Customer;
use App\Cicilan;
use App\Bank;
use App\Pelunasan;
use App\Supplier;

use App\Exports\SaleExport;
use App\Exports\KasMasukExport;


use Illuminate\Support\Facades\Input;
use Excel;

class ReportController extends Controller
{
    public function index_kasmasuk()
    {
		$prj = ProjectRumah::all();

		$awal = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
		$akhir = date('Y-m-d');
		
		return view('report.index_kasmasuk', compact('prj', 'awal','akhir')); 
    }
    
    public function index_sale()
    {
		$prj = ProjectRumah::all();

		$awal = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
		$akhir = date('Y-m-d');
		
		return view('report.index_sale', compact('prj', 'awal','akhir')); 
    }    
    
    public function index_stock()
    {
	
		$sup      = Supplier::all();
		$gdg      = Gudang::all();
		
		return view('report.index_stock', compact('sup','gdg')); 
    }    
    
    public function index_pelunasan()
    {
		$gdg = Gudang::all();

		$awal = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
		$akhir = date('Y-m-d');
		
		return view('report.index_pelunasan', compact('gdg', 'awal','akhir')); 
    }    
    
    public function index_hutang()
    {
		$gdg      = Gudang::all();	
		return view('report.index_hutang', compact('gdg')); 
    }    
    
    public function index_piutang()
    {
		$prj = ProjectRumah::all();	
		return view('report.index_piutang', compact('prj')); 
    }        

    public function index_pajak()
    {
		$customer = Customer::all();
		$sup      = Supplier::all();
		$sls      = Salesman::all();
		
		$awal = date('Y-m-d', mktime(0,0,0, date('m'), 1, date('Y')));
		$akhir = date('Y-m-d');
		
		return view('report.index_pajak', compact('customer', 'awal','akhir', 'sup','sls')); 
    }
    
   
    public function index_jurnal(){
        return view('report.index_jurnal');
    }
    
    public function show(){
        
    }
    
    
    public function pilihsupp(){
        
        $sup = Supplier::all();
        
        $data = [];
        foreach($sup as $list){
       
            $row = [];
            $row[] = $list->sup_nama;
            $row[] ="<label class='switch'>
                        <input type='checkbox' name='id[]'' value='".$list->id."'>
                        <span class='slider round'></span>
                    </label>";

            $data[] = $row;
        }


        $output = ["data" => $data];
        return response()->json($output);
    }        

    
    public function jurnal(Request $request){
        $tgl = $request['tgl'];
        
        $inv  = Invoice::with('get_supplier')
                        ->where('inv_tgl', $tgl)->get();
                            
        $sale = MSSale::with('get_customer', 'get_sales')
                        ->where('sale_tgl', $tgl)->get();
        
        $mts = MSMutasi::with('get_gudangasal', 'get_gudangtuju')
                        ->where('mts_tgl', $tgl)->get();
                        
        $rtr = MSRetur::with('get_customer')
                        ->where('rtr_tgl', $tgl)->get();
                        
        $adainv     = $inv->count();
        $adasale    = $sale->count();
        $adamts     = $mts->count();
        $adartr     = $rtr->count();
        
        return view('report.jurnal', compact('inv','sale', 'mts', 'rtr', 'tgl', 'adainv', 'adasale', 'adamts', 'adartr'));
        
    }
    
    public static function getReportMasuk($tgl1, $tgl2, $prj){
        
        $dt = DB::table('dt_cicilan as A')
                    ->select('B.project_name','C.cluster','C.block','C.nomor','D.cus_name','A.cicil_no','A.cicil_tgl','cicil_nominal')
                    ->addselect(DB::raw('CASE A.cicil_type WHEN "1" THEN "CASH"
                         WHEN "2" THEN "TRANSFER" WHEN "3" THEN "CEK/GIRO" END as tipe'))
                    ->leftjoin('dt_transaksi as E', function($join){
                            $join->on('A.trans_id', '=', 'E.id');
                        })
                    ->leftjoin('ms_project as B', function($join){
                            $join->on('E.project_id', '=', 'B.id');
                        })
                    ->leftjoin('ms_rumah as C', function($join){
                            $join->on('E.rumah_id', '=', 'C.id');
                        })
                    ->leftjoin('ms_customer as D', function($join){
                            $join->on('E.cust_id', '=', 'D.id_cust');
                        })
                    ->whereBetween('A.cicil_tgl', [$tgl1, $tgl2])
                    ->where('E.project_id', '=', $prj)
                    ->orderBy('A.cicil_no')
                    ->get();

        
        return $dt;
        
    }
    
    public function viewreportPemasukan(Request $request){
        
        $tgl1 = $request['awal'];
        $tgl2 = $request['akhir'];
        $prj  = $request['prj'];
        
        $project = ProjectRumah::find($prj);

        $dt = $this->getReportMasuk($tgl1, $tgl2, $prj);
        
        $ttl=0;
        $no =1;
        foreach($dt as $dd){ $ttl += $dd->cicil_nominal; }
                    
        return view('report.reportkas', compact('dt', 'tgl1', 'tgl2','project','no','ttl'));
    }

    public function viewreportPelunasan(Request $request){
        
        $tgl1 = $request['awal'];
        $tgl2 = $request['akhir'];
        $idgdg  = $request['prj'];
        
        $gdg = Gudang::find($idgdg);

        $dt = $this->getReportLunas($tgl1, $tgl2, $idgdg);
        
        $ttl=0;
        $no =1;
        foreach($dt as $dd){ $ttl += $dd->nominal; }
                    
        return view('report.reportlunas', compact('dt', 'tgl1', 'tgl2','gdg','no','ttl'));
    }
    
    public function getReportLunas($tgl1, $tgl2, $gdg){
        
        $dt = DB::table('ms_pelunasan as A')
                    ->select('A.lunas_tgl','A.lunas_no','A.nominal','A.deskripsi', 'B.supp_id', 'C.sup_nama')
                    ->addselect(DB::raw('CASE A.lunas_type WHEN "1" THEN "TRANSFER"
                         WHEN "2" THEN "CASH" WHEN "3" THEN "CEK/GIRO" END as tipe'))
                    ->leftjoin('ms_invoice as B', function($join){
                        $join->on('A.inv_id', '=', 'B.id');   
                    })
                    ->leftjoin('ms_supp as C', function($join){
                        $join->on('B.supp_id', '=', 'C.id');
                    })
                    ->whereBetween('A.lunas_tgl',[$tgl1, $tgl2])
                    ->where('B.gudang_id', $gdg)
                    ->where('B.inv_lunas', 1)
                    ->get();
                    
        return $dt;
        
    }
    
    public function viewreportHutang(Request $request){
        
        $idgdg  = $request['prj'];
        
        $gdg = Gudang::find($idgdg);

        $dt = $this->getReportHutang($idgdg);
        
        $ttl=0;
        $no =1;
        foreach($dt as $dd){ $ttl += $dd->inv_netto; }
                    
        return view('report.reporthutang', compact('dt', 'gdg','no','ttl'));
    }

        public function getReportHutang($gdg){
        
        $dt = DB::table('ms_invoice as A')
                    ->select('A.supp_id', 'A.inv_tgl','A.no_urut','A.inv_no','A.inv_netto','B.sup_nama')
                    ->leftjoin('ms_supp as B', function($join){
                        $join->on('A.supp_id', '=', 'B.id');
                    })
                    ->where('A.gudang_id', $gdg)
                    ->where('A.inv_lunas', 0)
                    ->where('A.inv_batal', 0)
                    ->get();
                    
        return $dt;
        
    }

    public function viewreportSale(Request $request){
        
        $tgl1 = $request['awal'];
        $tgl2 = $request['akhir'];
        $prj  = $request['prj'];
        $tp   = $request['tipe'];
        $project = ProjectRumah::find($prj);

        $dt = $this->getReportSale($tgl1, $tgl2, $prj, $tp);
        
        $byr='';
        switch($tp){
            case "0": $byr="ALL Type";break;
            case "1": $byr="KPR"; break;
            case "2": $byr="CASH BERTAHAP"; break;
            case "3": $byr="CASH KERAS"; break;
        }
        
        
        $ttl=0;
        $ccl=0;
        $no =1;
        foreach($dt as $dd){ $ccl += $dd->total_cicilan; $ttl += $dd->harga_rumah; }
                    
        return view('report.reportsale', compact('dt', 'tgl1', 'tgl2','project','no','ttl','ccl','byr'));
    }    
    
    public static function getReportSale($tgl1, $tgl2, $prj, $tp){
        
        if($tp=="0"){
            $dt = DB::table('dt_transaksi as A')
                    ->select('B.project_name','C.cluster','C.block','C.nomor','D.cus_name','A.trans_no','A.tgl_book','A.harga_rumah','A.total_cicilan')
                    ->addselect(DB::raw('CASE A.status_trx WHEN "1" THEN "KPR"
                         WHEN "2" THEN "CASH BERTAHAP" WHEN "3" THEN "CASH KERAS" END as tipe'))
                    ->leftjoin('ms_project as B', function($join){
                            $join->on('A.project_id', '=', 'B.id');
                        })
                    ->leftjoin('ms_rumah as C', function($join){
                            $join->on('A.rumah_id', '=', 'C.id');
                        })
                    ->leftjoin('ms_customer as D', function($join){
                            $join->on('A.cust_id', '=', 'D.id_cust');
                        })
                    ->whereBetween('A.tgl_book', [$tgl1, $tgl2])
                    ->where('A.project_id', '=', $prj)
                    ->where('A.is_cancel',0)
                    ->orderBy('A.tgl_book')
                    ->get();
        }else{
            $dt = DB::table('dt_transaksi as A')
                    ->select('B.project_name','C.cluster','C.block','C.nomor','D.cus_name','A.trans_no','A.tgl_book','A.harga_rumah','A.total_cicilan')
                    ->addselect(DB::raw('CASE A.status_trx WHEN "1" THEN "KPR"
                         WHEN "2" THEN "CASH BERTAHAP" WHEN "3" THEN "CASH KERAS" END as tipe'))
                    ->leftjoin('ms_project as B', function($join){
                            $join->on('A.project_id', '=', 'B.id');
                        })
                    ->leftjoin('ms_rumah as C', function($join){
                            $join->on('A.rumah_id', '=', 'C.id');
                        })
                    ->leftjoin('ms_customer as D', function($join){
                            $join->on('A.cust_id', '=', 'D.id_cust');
                        })
                    ->whereBetween('A.tgl_book', [$tgl1, $tgl2])
                    ->where('A.project_id', '=', $prj)
                    ->where('A.status_trx','=',$tp)
                    ->where('A.is_cancel',0)
                    ->orderBy('A.tgl_book')
                    ->get();
            
        }
        
        return $dt;
        
    }    
        
/* report sisa angsuran/piutang */
    public function viewreportPiutang(Request $request){
        
        $prj  = $request['prj'];
        $tp   = $request['tipe'];
        $project = ProjectRumah::find($prj);

        $dt = $this->getReportPiutang($prj, $tp);
        
        $byr='';
        switch($tp){
            case "0": $byr="ALL Type";break;
            case "1": $byr="KPR"; break;
            case "2": $byr="CASH BERTAHAP"; break;
            case "3": $byr="CASH KERAS"; break;
        }
        
        
        $ttl=0;
        $ccl=0;
        $no =1;
        foreach($dt as $dd){ $ccl += $dd->total_cicilan; $ttl += $dd->harga_rumah; }
                    
        return view('report.reportpiutang', compact('dt', 'project','no','ttl','ccl','byr'));
    }    
    
    public static function getReportPiutang($prj, $tp){
        
        if($tp=="0"){
            $dt = DB::table('dt_transaksi as A')
                    ->select('B.project_name','C.cluster','C.block','C.nomor','D.cus_name','A.trans_no','A.tgl_book','A.harga_rumah','A.total_cicilan','A.bank_id')
                    ->addselect(DB::raw('CASE A.status_trx WHEN "1" THEN "KPR"
                         WHEN "2" THEN "CASH BERTAHAP" WHEN "3" THEN "CASH KERAS" END as tipe'))
                    ->leftjoin('ms_project as B', function($join){
                            $join->on('A.project_id', '=', 'B.id');
                        })
                    ->leftjoin('ms_rumah as C', function($join){
                            $join->on('A.rumah_id', '=', 'C.id');
                        })
                    ->leftjoin('ms_customer as D', function($join){
                            $join->on('A.cust_id', '=', 'D.id_cust');
                        })
                    ->where('A.project_id', '=', $prj)
                    ->where('A.is_cancel',0)
                    ->where('A.sisa', '>',0)
                    ->where('A.is_lunas', 0)
                    ->orderBy('A.tgl_book')
                    ->get();
        }else{
            $dt = DB::table('dt_transaksi as A')
                    ->select('B.project_name','C.cluster','C.block','C.nomor','D.cus_name','A.trans_no','A.tgl_book','A.harga_rumah','A.total_cicilan','A.bank_id')
                    ->addselect(DB::raw('CASE A.status_trx WHEN "1" THEN "KPR"
                         WHEN "2" THEN "CASH BERTAHAP" WHEN "3" THEN "CASH KERAS" END as tipe'))
                    ->leftjoin('ms_project as B', function($join){
                            $join->on('A.project_id', '=', 'B.id');
                        })
                    ->leftjoin('ms_rumah as C', function($join){
                            $join->on('A.rumah_id', '=', 'C.id');
                        })
                    ->leftjoin('ms_customer as D', function($join){
                            $join->on('A.cust_id', '=', 'D.id_cust');
                        })
                    ->where('A.project_id', '=', $prj)
                    ->where('A.is_cancel',0)
                    ->where('A.sisa', '>',0)
                    ->where('A.status_trx','=',$tp)
                    ->orderBy('A.tgl_book')
                    ->get();
            
        }
        
        return $dt;
        
    }    
        

    public function exportSale(Request $request){

	    /* initial format excel */
	    ob_end_clean(); 
		ob_start(); 
		
        $tgl1 = $request['awal'];
        $tgl2 = $request['akhir'];
        $prj  = $request['prj'];		
        $tp   = $request['tipe'];
		
		$file_xls = 'report_sale.xls';
		return Excel::download(new SaleExport($tgl1, $tgl2, $prj, $tp), $file_xls);

    }    

    public function exportKasMasuk(Request $request){

	    /* initial format excel */
	    ob_end_clean(); 
		ob_start(); 
		
        $tgl1 = $request['awal'];
        $tgl2 = $request['akhir'];
        $prj  = $request['prj'];		

		$file_xls = 'report_kas_masuk.xls';
		return Excel::download(new KasMasukExport($tgl1, $tgl2, $prj), $file_xls);

    }  


/*--------------report detail per unit rumah ---------------*/
    public function index_detail(){
        
        $prj = ProjectRumah::all();
        
        return view('report.index_detail', compact('prj'));
        
    }
    
    function infoPembeli($id){
        
        $dt = Transaksi::where('rumah_id', $id)
                            ->first();

        $rmh = MSRumah::find($dt->rumah_id);                           
        $cus = Customer::find($dt->cust_id);
        
        echo json_encode(array_merge(json_decode($cus, true), json_decode($rmh, true)));
    }
    
    public function viewreportDetail(Request $request){

        $prj  = $request['prj'];
        $idrmh= $request['id_rmh'];
        
        $project = ProjectRumah::find($prj);
        $rmh     = MSRumah::find($idrmh);
        $trx     = Transaksi::where('rumah_id', $idrmh)
                                ->first();
        $cus     = Customer::find($trx->cust_id);

        $dt = DB::table('dt_cicilan as A')
                    ->select('A.*')
                    ->addselect(DB::raw('CASE A.cicil_type WHEN "1" THEN "TRANSFER"
                         WHEN "2" THEN "CASH" WHEN "3" THEN "CASH KERAS" END as tipe'))
                    ->where('A.trans_id', $trx->id)
                    ->orderBy('A.cicil_tgl')
                    ->get();
        
        $ccl=0;
        $no =1;
        foreach($dt as $dd){ $ccl += $dd->cicil_nominal; }
                    
        return view('report.reportdetail', compact('dt', 'rmh','project','cus','no','ccl','trx'));
    }    

/*-------------------- report sale utk pajak -------------*/

    public function viewreportPajak(Request $request){
        
        $set = Setting::first();
        
        $tgl1 = $request['awal'];
        $tgl2 = $request['akhir'];
        

        return view('report.reportpajak', compact('dt','tgl1','tgl2'));
    }
    

    public function exportHutang(Request $request){

	    /* initial format excel */
	    ob_end_clean(); 
		ob_start(); 

        $sup  = $request['sup'];		

        $tgl = date('Y-m-d'); /* 2022-07-20 */
		$tglxls = substr($tgl,0,4).substr($tgl,5,2).substr($tgl,8,2);
		
		$file_xls = 'reporthutang_'.$tglxls.'.xls';
		
		return Excel::download(new HutangExport($sup), $file_xls);

    }       



}

