<?php

namespace App\Http\Controllers;

use Mike42\Escpos\Printer; 
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\RawbtPrintConnector;
use Mike42\Escpos\CapabilityProfile;

use Illuminate\Http\Request;
use DataTables;
use Auth;
use DB;
use Session;
use Redirect;

use App\User;
use App\City;
use App\User_logs;
use App\Setting;
use App\ProjectRumah;
use App\MSRumah;
use App\Transaksi;
use App\Customer;



class RumahController extends Controller
{
    
    public function index(){

        $prj=ProjectRumah::all();

        return view('rumah.index',compact('prj'));
    }
    
    public function datarumah($id){
    
        $pj = ProjectRumah::find($id);
        $rmh= MSRumah::with('get_project')
                        ->where('project_id', $id)
                        ->orderBy('cluster','ASC')
                        ->orderBy('Block', 'ASC')
                        ->orderBy('nomor', 'ASC')
                        ->get();
                        
        $data=[];
        foreach($rmh as $dt){
            
            $sts='';
            /*
            if($dt->is_sold=="1"){
                $sts='<label class="label-success"> Sold </label>';
            }*/
            
            $row=[];
            $row[] = $dt->get_project->project_name;
            $row[] = $dt->cluster;
            $row[] = $dt->block;
            $row[] = $dt->nomor;
            $row[] = $dt->luasrumah.'/'.$dt->luastanah;
            //$row[] = $dt->lantai;
            $row[] = '<div class="text-right">'.format_uang($dt->harga).'</div>';
            
            if($dt->is_sold=="1"){
                
                $tr = Transaksi::where('rumah_id', $dt->id)->first();
                $tp = $tr->status_trx;
                
                switch($tp){
                    case '1': $sts='<label class="label-success">&nbsp;KPR&nbsp;</label>
                        <a onclick="termin('.$dt->id.')" class="btn btn-sm btn-flat"><i class="fa fa-plus-square-o"></i></a>';break;
                    case '2': $sts='<label class="label-warning">&nbsp;CB&nbsp;</label>';break;
                    case '3': $sts='<label class="label-info">&nbsp;CK&nbsp;</label>';break;
                }
                
                $row[] = $sts;

            }else{
                $row[]='';
            }
            
            $row[] = $dt->deskripsi;
            
            if($dt->is_sold=="1"){
                $row[] = '<div class="btn-group">
                        <a onclick="infoRumah('.$dt->id.')" class="btn btn-sm btn-flat"><i class="fa fa-info-circle"></i></a>
                      </div>';
                
            }else{
                $row[] = '<div class="btn-group">
                        <a onclick="editRumah('.$dt->id.')" class="btn btn-sm btn-flat"><i class="fa fa-pencil"></i></a>
                      </div>';
            }
            
            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
        
    }

    public function listrumah($id){
    
        $pj = ProjectRumah::find($id);
        $rmh= MSRumah::with('get_project')
                        ->where('project_id', $id)
                        ->orderBy('cluster','ASC')
                        ->orderBy('Block', 'ASC')
                        ->orderBy('nomor', 'ASC')
                        ->get();
                        
        $data=[];
        foreach($rmh as $dt){
            
            $sts='';
            if($dt->is_sold=="1"){
                $sts='<label class="label-success">Sold</label>';
            }
            
            $row=[];
            $row[] = $dt->get_project->project_name;
            $row[] = $dt->cluster;
            $row[] = $dt->block;
            $row[] = $dt->nomor;
            $row[] = $dt->luasrumah.'/'.$dt->luastanah;
            $row[] = $dt->lantai;
            $row[] = '<div class="text-right">'.format_uang($dt->harga).'</div>';
            $row[] = $sts;
            $row[] = $dt->deskripsi;

            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
        
    }    

    public function store(Request $request){

        $dt = new MSRumah;
        
        $dt->project_id = $request['id_project']; 
        $dt->cluster    = strtoupper($request['clust']);
        $dt->block      = strtoupper($request['blok']);
        $dt->nomor      = $request['nomor'];
        $dt->harga      = $request['harga'];
        $dt->luastanah  = $request['tanah'];
        $dt->luasrumah  = $request['bangun'];
        $dt->lantai     = $request['lantai'];
        $dt->deskripsi  = $request['ket'];        
        $dt->user_id    = Auth::user()->id;
        
        $dt->save();

		echo json_encode(array('msg'=>'success'));        
        
    }
    
    public function daftarRumah($id){
    
        $pj = ProjectRumah::find($id);
        $rmh= MSRumah::with('get_project')
                        ->where('project_id', $id)
                        ->where('is_sold', 0)
                        ->orderBy('cluster','ASC')
                        ->orderBy('Block', 'ASC')
                        ->orderBy('nomor', 'ASC')
                        ->get();
                        
        $data=[];
        foreach($rmh as $dt){
            
            $row=[];
            $row[] = $dt->get_project->project_name;
            $row[] = $dt->cluster;
            $row[] = $dt->block.'/'.$dt->nomor;
            $row[] = $dt->luasrumah.'/'.$dt->luastanah;
            $row[] = '<div class="text-right">'.format_uang($dt->harga).'</div>';
            $row[] = '<div class="btn-btn">
                        <a onclick="selectRumah('.$dt->id.')" class="btn btn-sm btn-flat"><i class="fa fa-check"></i></a>
                      </div>';

            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
        
    }        
    
/* daftar rumah terjual utk report detail */    
    public function daftarRumahSold($id){
    
        $pj = ProjectRumah::find($id);
        $rmh= MSRumah::with('get_project')
                        ->where('project_id', $id)
                        ->where('is_sold', 1)
                        ->orderBy('cluster','ASC')
                        ->orderBy('Block', 'ASC')
                        ->orderBy('nomor', 'ASC')
                        ->get();
                        
        $data=[];
        foreach($rmh as $dt){
            
            $row=[];
            $row[] = $dt->get_project->project_name;
            $row[] = $dt->cluster;
            $row[] = $dt->block.'/'.$dt->nomor;
            $row[] = $dt->luasrumah.'/'.$dt->luastanah;
            $row[] = '<div class="text-right">'.format_uang($dt->harga).'</div>';
            $row[] = '<div class="btn-btn">
                        <a onclick="selectRumah('.$dt->id.')" class="btn btn-sm btn-flat"><i class="fa fa-check"></i></a>
                      </div>';

            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
        
    }            
    
    
    public function edit($id){
        $dt = MSRumah::find($id);
        $prj = ProjectRumah::find($dt->project_id);
        
        echo json_encode(array_merge(json_decode($prj, true),json_decode($dt, true)));

    }
    
    
    public function infoRumah($id){
        
        $rmh = MSRumah::find($id);
        $trx = Transaksi::where('rumah_id', $id)
                            ->first();
                            
        $prj = ProjectRumah::find($trx->project_id);
        $cus = Customer::find($trx->cust_id);
                
        
        echo json_encode(array_merge(json_decode($prj, true),json_decode($trx, true), json_decode($rmh, true), json_decode($cus, true)));

    }

    public function show($id){
        $dt = MSRumah::find($id);
        echo json_encode($dt);
    }
    
    public function update(Request $request, $id){

        $dt = MSRumah::find($id);
        
        $dt->cluster    = strtoupper($request['clust']);
        $dt->block      = strtoupper($request['blok']);
        $dt->nomor      = $request['nomor'];
        $dt->harga      = $request['harga'];
        $dt->luastanah  = $request['tanah'];
        $dt->luasrumah  = $request['bangun'];
        $dt->lantai     = $request['lantai'];
        $dt->deskripsi  = $request['ket'];        
        $dt->user_id    = Auth::user()->id;
        $dt->update();
        
		echo json_encode(array('msg'=>'success'));        
        
    }

    public function dataDetail($id){
        
        $msl = MSSale::find($id);
        $dsl = DTSale::with('get_product')
                        ->where('sale_id', $id)
                        ->get();
                        
        $data=[];
        $ttl=0;
        foreach($dsl as $dt){
            
            $jlh=($dt->qty * $dt->harga)-($dt->qty * $dt->harga * $dt->disc_1/100);
            $ttl+= $jlh;
            
            $row=[];
            $row[]=$dt->get_product->kode_brg;
            $row[]=$dt->get_product->nama_brg;
            $row[]=$dt->kemasan.'/'.$dt->isi;
            $row[]='<div style="text-align:right">'.format_uang($dt->harga).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div style="text-align:right">'.$dt->disc_1.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div style="text-align:right">'.$dt->disc_2.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div style="text-align:right">'.$dt->qty.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[]='<div style="text-align:right">'.format_uang($jlh).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            
            if($msl->is_posted==1){
                $row[]="";
            }else{
                $row[]='<a onclick="editDetail('.$dt->id.')" class="btn btn-flat btn-xs"><i class="fa fa-pencil"></i></a>';
            }
            
            $data[]=$row;
        }
        
        $row=[];
        $row[]="";
        $row[]="";
        $row[]="";
        $row[]="";
        $row[]="";
        $row[]="Sub Total";
        $row[]="";        
        $row[]='<div style="text-align:right">'.format_uang($ttl).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
        $row[]="";
            
        $data[]=$row;     
        
        return response()->json(["data"=>$data]);
    }
    


    public function loadSummary($id){
        
        $msl = MSSale::find($id);
        $dt = DTSale::where('sale_id', $id)
                            ->get();
        $sub=0;
        foreach($dt as $list){
            $sub += ($list->qty * $list->harga)-($list->qty * $list->harga * $list->disc_1/100);
        }
        
        $dis = $sub * $msl->sale_disc /100;
        $ppn = ($sub - $dis) * $msl->sale_ppn/100;
        $ttl = $sub - $dis + $ppn;
        
        $msl->sale_brutto   = $sub;
        $msl->sale_netto    = $ttl;
        $msl->update();
        
        echo json_encode(["totalftr"=>format_uang($ttl)]);
    }	
    
    public function addDetail(Request $request){
        
        $idmsl = $request['idsale2'];       
        $idprd = $request['prd2'];
        $qty   = $request['qty'];
        
        $set = Setting::first();
        
        $msl = MSSale::find($idmsl);
        $cust= Customer::find($msl->sale_cust);
        $prd = Product::find($idprd);
        $sub = ProductSub::find($request['kms']);
        
        $hg = $sub->harga;
        if($cust->is_ppn==0){ $hg = $sub->harga + ($sub->harga*$set->ppn_value/100); }
        
        try{  
            $dt = new DTSale;
            
            $dt->sale_id        = $msl->id;
            $dt->product_id     = $prd->id;
            $dt->product_name   = $prd->nama_brg;
            $dt->sub_id         = $request['kms'];
            $dt->kemasan        = $sub->satuan;
            $dt->isi            = $sub->volume;
            $dt->harga          = $hg;
            $dt->disc_1         = $request['dis1'];
            $dt->qty            = $qty;
            $dt->save();
            
            $this->updStock($prd->id, $qty * $sub->volume);
            
            echo json_encode(['msg'=>'success']);
        }
        catch (Exeption $e){
            return response (['status' => false,'errors' => $e->getMessage()]);
        }            
    }
    
    public function updStock($id, $qty ){

        $gdg = Gudang::where('is_utama',1)
                        ->first();
        
        $stk = Stock::where('product_id', $id)
                        ->where('gudang_id', $gdg->id)
                        ->first();
        
        if(empty($stk)){
            $dt = New Stock;
            $dt->gudang_id  = $gdg->id;
            $dt->product_id = $id;
            $dt->stock_sale = $qty;
            $dt->tgl_sale   = date('Y-m-d');
            $dt->stock_akhir -= $qty;
            $dt->save();
        }else{
            
            $stk->stock_sale    += $qty;
            $stk->stock_akhir   -= $qty;
            $stk->tgl_sale       = date('Y-m-d');
            $stk->update();
        }
        
        return true;
    }
    
    public function editDetail($id){
        
        $dt = DTSale::find($id);
        echo json_encode($dt);
        
    }
    

    public function printFaktur($id){
        
        $msl = MSSale::find($id);
        $dt  = DTSale::with('get_product')
                            ->where('sale_id', $id)
                            ->get();  
                            
        $cus = Customer::find($msl->sale_cust);                    
        $sls = Salesman::find($msl->sales_id);
        $area= Area::find($cus->cus_area);
                            
        $sub=0;
        foreach($dt as $list){
            $sub += ($list->qty * $list->harga)-($list->qty * $list->harga * $list->disc_1/100);
        }
        
        $dis = $sub * $msl->sale_disc /100;
        $ppn = ($sub - $dis) * $msl->sale_ppn/100;
        $ttl = round($sub - $dis + $ppn);
        
        return view('sales.faktur', compact('msl','dt','sub', 'dis','ppn','ttl','sls','cus','area'));
    }
    
    public function posting(Request $request){
        //return json_encode(['msg'=>'success']);
        $dt = MSSale::find($request['idsale']);
        $dt->is_posted=1;
        $dt->update();
        
        echo json_encode(['msg'=>'success']);        
    }
    
    public function history_sale(){
        return view('sales.history');
    }    
    
     public function datahistory(){

        $sl = MSSale::with('get_customer','get_sales')
                        ->where('is_posted',1)
                        ->orderBy('sale_no', 'DESC')
                        ->get();
                        
        $data=[];
        foreach($sl as $dt){
            
            $row=[];
            $row[] = $dt->sale_no;
            $row[] = tanggal_indonesia($dt->sale_jt, false);
            $row[] = $dt->get_customer->cus_name;
            $row[] = $dt->get_sales->sales_name;
            $row[] = $dt->sale_disc;
            $row[] = $dt->sale_ppn;
            $row[] = '<div style="text-align:right">'.format_uang($dt->sale_netto).'</div>';
            
            $row[]='<a onclick="showDetail('.$dt->id.')" class="btn btn-info btn-sm"><i class="fa fa-eye"></i></a>';
                        
            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
        
    }
 

    
}
