<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use App\Gudang;
use App\Stock;
use App\StockHistory;
use App\MSOpname;
use App\DTOpname;
use App\User_logs;
use DataTables;
use DB;
use Auth;
Use Redirect;

class StockOpnameController extends Controller
{

	public function index()
	{		
	    $gdg    = Gudang::all();
	    $prd    = Product::orderBy('nama_brg','ASC')
	                            ->get();
	                            
		return view('stockopname.index', compact('gdg', 'prd'));
	}
	
	public function history()
	{		
		$cabang = Cabang::all();
		
		return view('stockopname.history', compact('cabang'));
	}	

//------------------------------history detail


    function getheader()
    {
		$tglnow = date("Y-m-d");
		
        $dt = MSOpname::with('get_gudang')
                        ->orderBy('opn_tgl', "DESC")
                        ->get();
		
		$data = [];
		
		foreach($dt as $list)
		{
			$row = [];
				   
			$row[] = $list->opn_tgl;
			$row[] = $list->get_gudang->kode." - ".$list->get_gudang->nama;
            $row[] = $list->deskripsi;
            
	        $sss = $list->is_posted;
			$sts="";
				switch ($sss){
					case '0': $sts = 'Not Posted'; break;
					case '1': $sts = 'Posted'; break;}
			$row[] = $sts;

			if($list->is_posted==1){
			    $row[]="";    
			}else{
		        $row[] = '<div class="btn-btn">
				   <a onclick="addData('.$list->id.')" class="btn btn-success btn-sm"><i class="fa fa-plus"> detail </i></a>
				   </div>';	
			}
			
		    $data[] = $row;
		}

		return response()->json(["data"=>$data]);								
			
    }
/*------------------------------------------------------*/
    function history_header()
    {

     	$invoice = Invoice::leftjoin('ms_supp', 'ms_invoice.supp_id','=','ms_supp.id_supp')
								->where('ms_invoice.inv_posted',1)
								->where('ms_invoice.inv_batal',0)
								->orderby('ms_invoice.inv_tgl','DESC')->get();
		
		$no=1;
		$data = array();
		
		foreach($invoice as $list)
		{
			$row = array();
				   
			$row[] = $no++;
			$row[] = $list->inv_no;
			$row[] = tanggal_indonesia($list->inv_tgl, false);
			$row[] = $list->sup_nama." /".$list->sup_kota;
			$row[] = '<div class="text" align="right">'.format_uang($list->inv_total).'</div>';
			
			$sss= $list->inv_lunas;
			$sts="";
				switch ($sss){
					case '0': $sts = 'Blm Lunas'; break;
					case '1': $sts = 'LUNAS'; break;}

			$row[] = $sts;
			$row[] = '<div class="btn-btn">
				   <a href="/sbo/invoice/'.$list->id_invoice.'/tampil" class="btn btn-success btn-sm"><i class="fa fa-list"> detail</i></a>
				   <a href="/sbo/invoice/'.$list->id_invoice.'/reprint" class="btn btn-danger btn-sm"><i class="fa fa-print"> reprint</i></a>
				   </div>';	
		   $data[] = $row;
		}

		$output = array("data" => $data);
		return response()->json($output);								
			
    }

///-- create new opname
	public function store(Request $request)
	{
		$gdg		= $request['gdg'];
        $gudang     = Gudang::find($gdg);
        
		$stopname	= New MSOpname;
		
		$stopname->gudang_id	= $gdg;
		$stopname->opn_tgl	    = date('Y-m-d');
		$stopname->deskripsi    = $request['ket'];
		$stopname->user_id	    = Auth::user()->id;
		
		$stopname->save();

	// insert logs
			$usrnm	= Auth::user()->username;
			
			$userlog = New User_logs;
			$userlog->title		= 'Stock Opname Baru';
			$userlog->content	= 'Stock Opname '.$gudang->nama.' berhasil dicreate oleh '.$usrnm;
			$userlog->user_id	= Auth::user()->id;
			$userlog->save();

			echo json_encode(['msg'=>'success']);
			       			
	}

    public function edit($id)
    {
      $opn = MSOpname::with('get_gudang')
                        ->where('id',$id)
                        ->first();
                        
      echo json_encode($opn);
    }
    
 
    public function show($id)
    {
        
    }

    public function dataDetail($id){
        
        $opn = MSOpname::find($id);
        $dtl = DTOpname::where('opn_id', $id)
                        ->get();
                        
        $data=[];
        $ttl=0;
        foreach($dtl as $dt){
            
            $row=[];
            $row[]=$dt->product_name;
            $row[]=$dt->satuan.'/'.$dt->isi;
            $row[]='<div style="text-align:right">'.format_uang($dt->opn_qty).'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            
            if($opn->is_posted==1){
                $row[]="";
            }else{
                $row[]='<a onclick="editDetail('.$dt->id.')" class="btn btn-flat btn-xs"><i class="fa fa-pencil"></i></a>';
            }
            
            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
    }
    
    public function listKemasan($id){
        
        $kms = ProductSub::where('product_id', $id)
                            ->get();
        
		$data = [];
		
	    foreach($kms as $list){
    		    
		    $hg=$list->harga;
			$row = [];
			$row[] = $list->satuan ;
            $row[] = $list->volume ;
            $row[] = '<div style="text-align:right">'.format_uang($hg).'</div>' ;
    			
  		    $row[] = '<div class="btn-btn">
						<a onclick="selectKemasan('.$list->id.')" class="btn btn-primary btn-sm"><i class="fa fa-check"></i></a>
					</div>';
    
			$data[] = $row;
        }

        return response()->json(["data"=>$data]);        
    }
    
    public function addDetail(Request $request){

        $idopn  = $request['idopn2'];       /* pada form add_detail */
        $idprd  = $request['prd2'];
        $qty    = $request['qty'];
        
        $mopn = MSOpname::find($request['idopn2']);
        $stk  = Stock::where('product_id',$idprd)
                        ->where('gudang_id', $mopn->gudang_id)
                        ->first();
        
        $prd = Product::find($idprd);
        $dt = new DTOpname;
        
        $dt->opn_id     = $idopn;
        $dt->product_id = $prd->id;
        $dt->product_name = $prd->nama_brg;
        $dt->opn_qty    = $qty;
        $dt->sisa_stock = $stk->stock_akhir;
        $dt->satuan     = $prd->satuan;
        $dt->isi        = $prd->isi;
        
        $dt->save();
        
        echo json_encode(["msg"=>"success"]);
    }

    public function editDetail($id){
    
        $dt = DTOpname::find($id);
        echo json_encode($dt);
        
    }
    
    public function simpanEdit(Request $request, $id){
        
        $dt = DTOpname::find($id);
        $mopn = MSOpname::find($dt->opn_id);
        $stk  = Stock::where('product_id',$dt->product_id)
                        ->where('gudang_id', $mopn->gudang_id)
                        ->first();

        $qty    = $request['qty'];

        $dt->sisa_stock = $stk->stock_akhir;
        $dt->opn_qty    = $qty;
        $dt->update();
        
        echo json_encode(["msg"=>"success"]);        
    }


    public function posting(Request $request){
    
        $opn = MSOpname::find($request['idopn']);
        $dt  = DTOpname::where('opn_id', $opn->id)
                                ->where('is_posted', 0)
                                ->get();
        
        /** pindahkan data stock lama ke history stock dan reset */

            $this->simpanHistory($opn->gudang_id);
            $this->resetStock($opn->gudang_id);
   
        
        /* update new stock */
        foreach($dt as $list){
            
            $this->updStock($list->product_id, $list->opn_qty * $list->isi, $opn->gudang_id);
            
            /* update status posting */
            $pp = DTOpname::find($list->id);
            $pp->is_posted = 1;
            $pp->update();
            
        }
        
        $opn->is_posted=1;
        $opn->update();
        
        echo json_encode(['msg'=>'success']);
    }

    public function resetStock($gdg){
        $dt = Stock::where('gudang_id', $gdg)
                        ->get();
                        
        foreach($dt as $dd){                
            
            $old = Stock::find($dd->id);
            
            $old->stock_awal    = 0;
            $old->stock_in      = 0;
            $old->stock_out     = 0;
            $old->stock_retur   = 0;
            $old->stock_mts_out = 0;
            $old->stock_mts_in  = 0;
            $old->stock_bs      = 0;
            $old->stock_cn      = 0;
            $old->stock_adjust  = 0;
            $old->update();
        }
        
        return true;
    }

    public function simpanHistory($gdg){
        $dt = Stock::where('gudang_id', $gdg)
                        ->get();
                        
        foreach($dt as $old){                        

            $his = new StockHistory;
            $his->hist_tgl      = date('Y-m-d');
            $his->gudang_id     = $old->gudang_id;
            $his->product_id    = $old->product_id;
            $his->stock_awal    = $old->stock_awal;
            $his->stock_in      = $old->stock_in;
            $his->stock_out     = $old->stock_out;
            $his->stock_retur   = $old->stock_retur;
            $his->stock_mts_out = $old->stock_mts_out;
            $his->stock_mts_in  = $old->stock_mts_in;
            $his->stock_bs      = $old->stock_bs;
            $his->stock_cn      = $old->stock_cn;
            $his->stock_adjust  = $old->stock_adjust;
            $his->stock_akhir   = $old->stock_akhir;
            $his->tgl_awal      = $old->tgl_awal;
            $his->tgl_in        = $old->tgl_in;
            $his->tgl_out       = $old->tgl_out;
            $his->tgl_retur     = $old->tgl_retur;
            $his->tgl_mts_out   = $old->tgl_mts_out;
            $his->tgl_mts_in    = $old->tgl_mts_in;
            $his->tgl_bs        = $old->tgl_bs;
            $his->tgl_cn        = $old->tgl_cn;
            $his->tgl_adjust    = $old->tgl_adjust;
            $his->save();
            
        }
        
        return true;
    }



    public function updStock($id, $qty, $gdg ){
        
        $stk = Stock::where('product_id', $id)
                        ->where('gudang_id', $gdg)
                        ->first();
                        
        if(empty($stk)){
            $dt = New Stock;
            $dt->gudang_id  = $gdg;
            $dt->product_id = $id;
            $dt->stock_awal = $qty;
            $dt->tgl_awal   = date('Y-m-d');
            $dt->stock_akhir= $qty;
            $dt->save();
        }else{
            
            $stk->stock_awal  = $qty;
            $stk->stock_akhir = $qty;
            $stk->tgl_awal    = date('Y-m-d');
            $stk->update();
        }
        
        return true;
    }
    
    
    
    
    public function printFaktur($id){
        
        $opn = MSOpname::find($id);
        $gdg = Gudang::find($opn->gudang_id);
        $dt  = DTOpname::with('get_product')
                                ->where('opn_id', $id)
                                ->get();  
                            
        return view('stockopname.faktur', compact('opn','dt','gdg'));
    }
    	
}
