<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Supplier;
use App\User_logs;
use App\City;
use App\Product;
use App\ProductSup;

use Auth;
use DB;
use DataTables;
use Session;

use App\Imports\SupplierImport;
use Illuminate\Support\Facades\Input;
use Excel;

class SupplierController extends Controller
{
    public function index()
    {
        $kota = City::all();

        return view('supplier.index', compact('kota')); 
    }

    public function listData()
    {
   
        $supplier = Supplier::orderBy('sup_nama', 'desc')->get();

        $data = [];
     
        foreach($supplier as $list){

            $row = [];

            $row[] = $list->sup_nama;
            $row[] = $list->sup_alamat;
            $row[] = $list->sup_telp;
            $row[] = $list->sup_kontak;
            $row[] = $list->lama_kredit.' Hari';
            $row[] = '<div class="btn-btn">
                        <a onclick="editForm('.$list->id.')" class="btn btn-outline-success btn-xs"><i class="fa fa-pencil"></i></a>
                        <a onclick="addList('.$list->id.')" class="btn btn-outline-danger btn-xs"><i class="fa fa-list"></i></a>
			          </div>';
            $data[] = $row;
        }

        return response()->json(["data"=>$data]);
    }
   
    public function listProduct($id){

        $lst = DB::table('product_sup as A')
                    ->select('A.id','A.sup_id','A.product_id', 'B.nama_brg','A.satuan','A.isi','A.harga')
                    ->leftjoin('ms_product as B', function($join){
                            $join->on('A.product_id','=','B.id');
                        })
                    ->where('A.sup_id', $id)
                    ->get();

        $data=[];
        foreach($lst as $dt){
            
            $row=[];
            $row[] = $dt->nama_brg;
            $row[] = $dt->satuan.'/'.$dt->isi;
            $row[]= '<div class="text-right">'.format_uang($dt->harga).'&nbsp;&nbsp;&nbsp;&nbsp;</div>';
            $row[] = '<div class="btn-btn">
                        <a onclick="delproduct('.$dt->id.')" class="btn btn-outline-danger btn-xs"><i class="fa fa-trash"></i></a>
			          </div>';            
            
            $data[]= $row;
        }
        
        return response()->json(["data"=>$data]);
    }
   
    public function productSup($id){
        $prd = ProductSup::where('sup_id', $id)
                            ->get();
                            
        $exist=[];
        foreach($prd as $dt){ $exist[]=$dt->product_id; }
        
        $newprd = Product::whereNotIn('id',$exist)
                            ->get();
        $data=[];                    
        foreach($newprd as $dd){
            
            if($dd->is_stock==1){ $inv="Ya"; }else{ $inv="No"; }
            
            $row=[];
            $row[]=$dd->nama_brg;
            $row[]=$dd->satuan.'/'.$dd->isi;
            $row[]='<div class="text-right">'.format_uang($dd->harga).'</div>';
            $row[]=$inv;
            $row[] = '<div class="btn-btn">
                        <a onclick="selectItem('.$dd->id.')" class="btn btn-outline-danger btn-xs"><i class="fa fa-plus"></i></a>
			          </div>';            
            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);
    }
    
    public function simpanProduct(Request $request, $id){
        $sup = $request['idsup'];
        $prd = Product::find($id);
        
        $lst = new ProductSup;
        $lst->sup_id        = $sup;
        $lst->product_id    = $id;
        $lst->satuan        = $prd->satuan;
        $lst->isi           = $prd->isi;
        $lst->harga         = $prd->harga;
        $lst->save();
        
        echo json_encode(["msg"=>"success"]);
    }
    
    public function delProduct($id){
        $lst = ProductSup::find($id);
        $lst->delete();
        
        echo json_encode(["msg"=>"success"]);
    }
   
    public function pricelist(){
        
        $sup = Supplier::orderBy('sup_nama')
                            ->get();
                            
        return view('supplier.productsup', compact('sup'));
    }
    
    public function listPrice($id){
        $prd = ProductSup::with('get_product')
                            ->where('sup_id', $id)
                            ->get();
                            
        $data=[];                    
        foreach($prd as $dd){
            
            $row=[];
            $row[]=$dd->get_product->nama_brg;
            $row[]=$dd->satuan.'/'.$dd->isi;
            $row[]='<div class="text-right">'.format_uang($dd->harga).'</div>';
            $row[] = '<div class="btn-btn">
                        <a onclick="editproduct('.$dd->id.')" class="btn btn-outline-danger btn-xs"><i class="fa fa-pencil"></i></a>
			          </div>';            
            $data[]=$row;
        }
        
        return response()->json(["data"=>$data]);        
    }
    
    function editList($id){
        
        $lst = ProductSup::find($id);
        $prd = Product::find($lst->product_id);
        
        echo json_encode(array_merge(json_decode($prd, true), json_decode($lst, true)));
    }
    

    
    function simpanEditList(Request $request, $id){
        
        $lst = ProductSup::find($id);
        $lst->satuan    = $request['stn'];
        $lst->isi       = $request['isi'];
        $lst->harga     = $request['harga'];
        $lst->save();
        
        echo json_encode(["msg"=>"success"]);
    }

//--------------------------------------

    public function pilihData()
    {
   
        $supplier = Supplier::orderBy('sup_nama', 'desc')->get();
        $no = 0;
        $data = [];
     
        foreach($supplier as $list){
            $no ++;
            $row = [];
   
            $row[] = $list->sup_nama;
            $row[] = $list->sup_alamat;
            $row[] = $list->sup_kota;
            $row[] = '<div class="btn-group">
                            <a href="pricelist/'.$list->id_supp.'/tampil" class="btn btn-outline-primary btn-xs"><i class="fa fa-check"></i></a>
        			   </div>';
        			      
            $data[] = $row;
	     
        }

        return response()->json(["data"=>$data]);
   }

//----------------

    public function store(Request $request)
    {
        $sup = new Supplier;
        
        $sup->sup_nama      = ucwords(strtolower($request['nama']));
        $sup->sup_alamat    = ucwords(strtolower($request['alamat']));
        $sup->sup_telp      = $request['telpon'];
	    $sup->sup_kota	    = $request['kota'];
	    $sup->is_pkp        = $request['pkp'];
	    $sup->sup_kontak    = $request['kontak'];
	    $sup->lama_kredit   = $request['kredit'];
	    $sup->save();
	  
// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title	= 'Tambah Master Supplier';
		$userlog->content	= 'Master Supplier '.$request['nama'].' berhasil ditambah oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
        $userlog->save();		
      
        echo json_encode(['msg'=>'success']);
    }

    public function edit($id)
    {
        $supplier = Supplier::find($id);
        echo json_encode($supplier);
    }

    public function update(Request $request, $id)
    {
        $sup = Supplier::find($id);

        $sup->sup_nama      = ucwords(strtolower($request['nama']));
        $sup->sup_alamat    = ucwords(strtolower($request['alamat']));
        $sup->sup_telp 	    = $request['telpon'];
	    $sup->sup_kota	    = $request['kota'];
	    $sup->is_pkp        = $request['pkp'];
	    $sup->sup_kontak    = $request['kontak'];
	    $sup->lama_kredit   = $request['kredit'];
        $sup->update();

// insert logs
		$usrnm	= Auth::user()->username;
		$userlog = New User_logs;
		$userlog->title	= 'Edit Master Supplier';
		$userlog->content	= 'Master Supplier '.$request['nama'].' berhasil diedit oleh '.$usrnm;
		$userlog->user_id	= Auth::user()->id;
        $userlog->save();	  
      
        echo json_encode(array('msg'=>'success'));
    }

    public function destroy($id)
    {
      $supplier = Supplier::find($id);
      $supplier->delete();
    }
   
    public function import_data(){
        return view('supplier.upload');
    }	

    public function importSupplier(Request $request) {
        
        if($request->file=="")
        	{ Session::flash('error','File harus dipilih ! ');
    		  return back();
		    }
        

        Excel::import(new SupplierImport, request()->file('file'));  
            
    	Session::flash('sukses','Data Supplier  Berhasil Diimport ! ');
    	return back();
        
    }   
   
   
}
