<head>

</head>

@extends('layouts.app')

@section('title')

@endsection

@section('breadcrumb')
   @parent
   <li>master account</li>
@endsection


@section('content')   
<div class="row">
	<div class="container-fluid">
		<div class="card">
			<div class="card-block">  
			
    <a onclick="addAccount()" class="btn btn-success btn-sm"><i class="fa fa-plus-circle"> </i> New Account </a> 			
    
<form method="post" id="form-project">
{{ csrf_field() }}


<table class="table table-hover table-striped table-bordered" id="tblaccount" width="100%">
<thead>
   <tr class="tblheader">
        
        <th width="80px">NO.Acct</th>
        <th width="150px">Nama Account</th>
        <th width="50px">Type</th>
        <th width="20px">D/K</th>
        <th width="150px">Keterangan</th>
        <th class="text-center" width="20px">Act</th>
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

			</div>
		</div>
	</div>	
</div>

@include('account.form_add')


@endsection

@section('script')
<script type="text/javascript">
var table, save_method;

$(function(){
    table = $('#tblaccount').DataTable({
        "processing" : true,
        "lengthMenu": [[8, 25, 50, -1], [8, 25, 50, "All"]],       //pilihan jumlah record show
        "ajax" : {
            "url" : "{{ route('account.dataaccount') }}",
            "type" : "GET"
        }
    }); 
});   

//submit
$('#form-create').validator().on("submit", function(e) {

    if(!e.isDefaultPrevented()){
		 
		$('#submit-control').html(' Simpan Create ... ');
		$('#submit-control').attr('disabled','disabled');
		  
        var id = $('#id').val();
        if(save_method == "add") { url = "{{ route('account.store') }}"; }
        else { url = "{{ DIR_APP }}account/"+id; }

        $.ajax({
            url : url,
            type : "POST",
            data : $('#form-create').serialize(),
            dataType: 'JSON',		   
            success : function(data){
			    if(data.msg=="error"){
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#kode').focus().select();
				}else{
					$('#modal-form_create').modal('hide');
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');		
					$('#tblaccount').DataTable().ajax.reload(null, false);
				}   
 		    },
            error : function(){
			    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			    $('#submit-control').html('Save');
			    $('#submit-control').removeAttr('disabled');			 
            }   
        });
        return false;
	}
});
   

function addAccount(){
    save_method = "add";
    $('input[name=_method]').val('POST');
    $('#modal-form_create').modal('show');
    $('#modal-form_create form')[0].reset();     
    $('#kode').removeAttr('readonly');
} 	 

function editAcct(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $.ajax({
     url : "account/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
        $('input[name=_method]').val('PATCH');
        $('#modal-form_create').modal('show');
        $('#modal-form_create form')[0].reset(); 
        
        $('#id').val(data.id);
        $('#kode').val(data.acct_no).prop('readonly',true);
        $('#nama').val(data.acct_name);
        $('#tipe').val(data.acct_tp);
        $('#dk').val(data.is_dk);
        $('#ket').val(data.deskripsi);

     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}

function formatAngka(x) {
    x = x.toString();
    var pattern = /(-?\d+)(\d{3})/;
    while (pattern.test(x))
        x = x.replace(pattern, "$1.$2");
    return x;
}


function printBiaya(id){
    window.location="{{ DIR_APP }}biaya/"+id+"/printrekap";
} 


</script>


@endsection
