@extends('layouts.app')


<head>
  
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
</head>

@section('content')
    <h4>Laravel Dropdown List</h4>
	
  <div class="form-group">
    <label for="merk" class="col-md-1 control-label">Brand</label>
    <div class="col-md-5">
      <select id="merk" type="text" class="form-control" name="merk" autofocus required>
        <option value=""> -- Pilih brand -- </option>
        @foreach($merks as $merk)
        <option value="{{ $merk->id_brd }}">{{ $merk->brd_kode.' - '.$merk->brd_name.' - '.$merk->id_brd }}</option>
        @endforeach
      </select>
    </div>
  </div>
	
	<br><br>
	
    <div class="row">
        <div class="col-md-4">
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
			
                <thead align="center">
                    <tr class="danger">
                        <th width="200px"><b>ID Prd</b></th>
                        <th width="200px"><b>ID Brand</b></th>
                        <th width="750px"><b>Nama Barang</b></th>
                    </tr>
                </thead>
                <tbody id="motors">
                @foreach($motors as $motor)
                    <tr>
                        <td>{{ $motor->id_sku }}</td>
                        <td>{{ $motor->brd_id }}</td>
                        <td>{{ $motor->sku_name }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
        </div>
    </div>

    <script type="text/javascript">
        $(document).ready(function(){
            $('#merk').on('change', function(e){
                var id = e.target.value;
				//alert(' pilih brand '+id);				
				
                $.get('{{ url('dropdown/merkAjax')}}/'+id, function(data){
                    console.log(id);
                    console.log(data);
                    $('#motors').empty();
                    $.each(data, function(index, element){
                        $('#motors').append("<tr><td>"+element.id_sku+"</td><td>"+element.brd_id+"</td>"+
                        "<td>"+element.sku_name+"</td></tr>");
						alert('pilihan '+element.id_sku);
                    });
                });
            });
        });
    </script>
@endsection
