@extends('layouts.print')

<head>
    <style>
        tr, td {font-size:1.75rem; }
    
        @page {
            size: A4;
            margin: 10mm 2mm 20mm 2mm;    

            @bottom-center {
                content: counter(page);
            }
        }
        
        @page :left: header {
            content: "Page " decimal(pageno), , first(chapter);
            font-variant: small-caps
        }
        @page :right :header {
            content: last(section), , "Page " decimal(pageno);
            font-variant: small-caps
        }    
    
        table.report-container {
            page-break-after:always;
        }
        thead.report-header {
            display:table-header-group;
        }
        tfoot.report-footer {
            display:table-footer-group;
        }    
    
        #tblisi th,td { border-bottom:1px black solid; }
        #tblisi th, td { font-size:13px; }
        
    </style>    
</head>

<body>
        
    <script type="text/javascript">
         //window.onload = addPageNumbers;

        function addPageNumbers() {
            var totalPages = Math.ceil(document.body.scrollHeight / 600);  //842px A4 pageheight for 72dpi, 1123px A4 pageheight for 96dpi, 
            for (var i = 1; i <= totalPages; i++) {
              var pageNumberDiv = document.createElement("div");
              var pageNumber = document.createTextNode("Page " + i + " of " + totalPages);
              pageNumberDiv.style.position = "absolute";
              pageNumberDiv.style.marginTop = "calc((" + i + " * (297mm )) - 400mm - 0.5px)"; //297mm A4 pageheight; 0,5px unknown needed necessary correction value; additional wanted 40px margin from bottom(own element height included)
              pageNumberDiv.style.marginTop = 1000px;
              pageNumberDiv.style.marginRight = 50px;
              pageNumberDiv.style.height = "16px";
              pageNumberDiv.appendChild(pageNumber);
              document.body.insertBefore(pageNumberDiv, document.getElementById("content"));
              pageNumberDiv.style.left = "calc(100% - (" + pageNumberDiv.offsetWidth + "px + 20px))";
            }
          }
    </script>


@section('title')
    Report Gaji  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

  	<!--a onclick="window.location='{{ route('home') }}'" class="btn btn-primary"><i class="fa fa-home"></i> Home </a-->
	<a onclick="window.history.go(-1)" class="btn btn-warning"><i class="fa fa-undo"></i> Back </a> 
	<a onclick="myFunction()" class="btn btn-success"><i class="fa fa-print"></i> Print Report</a>
    <!--a onclick="printmatrix()" class="btn btn-success"><i class="fa fa-print"></i>Print Faktur</a-->
 
    <script>
        function myFunction() {
          window.print();
        }
    </script>
@endsection

@section('breadcrumb')
   @parent
     <li>report gaji</li>
@endsection

@section('content')

<h4>REPORT GAJI </h4>
<h4 style="margin-top:-10px;">PERIODE : {{ $prd }}</h4>

<table class="report-container" cellspacing="5" cellpadding="5"  style="width:100%;" id="tblisi">
    
    <thead class="report-header">  
    
        <tr border="1">
        	<th width="35">NO</th>
        	<th width="60" class="text-center">NIP</th>
        	<th width="250" class="text-left">NAMA</th>
        	<th width="90" class="text-left">JABATAN</th>
        	<th width="90" class="text-right">GAJI POKOK</th>
        	<th width="90" class="text-right">TUNJ</th>
        	<th width="90" class="text-right">BONUS</th>
        	<th width="90" class="text-right">POT</th>
        	<th width="90" class="text-right">TOTAL</th>
        	<th width="5px">&nbsp;&nbsp;</th>
        	<th width="150" class="text-left">Notes</th>
        </tr>
    </thead>
    
    @foreach ($dt as $list)
    	<tr>
    	    <td width="35" align="right">{{ $no++ }}</td>
    	   	<td width="60" align="center">{{ $list->nip }}</td>
        	<td>{{ $list->nama }}</td>
        	<td>{{ $list->jabatan }}</td>
        	<td align="right">{{ format_uang($list->gaji_pokok) }}</td>
        	<td align="right">{{ format_uang($list->tunjangan) }}</td>
        	<td align="right">{{ format_uang($list->bonus) }}</td>
        	<td align="right">{{ format_uang($list->potongan) }}</td>
        	<td align="right">{{ format_uang($list->gaji_pokok + $list->tunjangan + $list->bonus - $list->potongan) }}</td>
        	<td>&nbsp;&nbsp;</td>
        	<td>{{ $list->bank.' - '.$list->noacct }}</td>
        </tr>
    @endforeach
    
    	<tr>
    	   	<td></td>
    	   	<td></td>
        	<td><b>GRAND TOTAL</b></td>
        	<td></td>
        	<td></td>
        	<td></td>
        	<td></td>
        	<td></td>
        	<td align="right"><b>{{ format_uang($ttl) }}</b></td>
        	<td></td><td></td>
        </tr>    
    
<!--tfoot class="report-footer">
    <tr><td></td><td><h6>#report sale</h6></td></tr>
</tfoot-->

    
</table>



<!--hr> <!--style="width:96%; margin-top:5px; margin-bottom:5px; background-color: black; height: 1px; border:1;"-->


@endsection

