<head>
    <style>
        #tblhutang th, tr, td {
            border-bottom:1px black solid; border-top:1px black solid;
        }   
        
        #tbl-info th, tr, td {
            border-bottom:1px black solid; border-top:1px black solid;
        } 
        
        #tbl-bayar  tr, td {
            border-bottom:1px black solid; border-top:1px black solid;
        } 
        
        
    </style>
</head>

@extends('layouts.app')

@section('title')

@endsection

@section('breadcrumb')
   @parent
   <li>Hutang Project </li>
@endsection


@section('content')   
<div class="row">
	<div class="container-fluid">
		<div class="card">
			<div class="card-block">  
			
    <h5>Hutang Project</h5>			
    <a onclick="addForm()" class="btn btn-success btn-sm" style="margin-top:-10px;margin-left:500px"><i class="fa fa-plus-circle"> </i> New Hutang </a> 			
    
<form method="post" id="form-project">
{{ csrf_field() }}

        <div class="form-group col-sm-6 col-md-6">
            <label>Project Perumahan</label>
            <select type="text" id="prj" name="prj" autofoucs class="form-control" style="font-weight:bold">
                <option value="0"> --- ALL Project --- </option>
                @foreach($prj as $list)
                    <option value="{{ $list->id }}">{{ $list->project_name }}</option>
                @endforeach
            </select>
        </div>        

<table class="table table-padding table-striped" id="tblhutang" width="100%">
<thead>
   <tr class="tblheader">
   
        <th width="100px">Perumahan</th>
        <th width="90px">Tanggal</th>
        <th width="100px" style="text-align:center">Nominal</th>
        <th width="100px" style="text-align:center">Pembayaran</th>
        <th width="40px">Sts</th>
        <th width="300px">Deskripsi</th>
        <th width="30px">Act</th>
 
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

			</div>
		</div>
	</div>	
</div>

@include('hutang.hutang_create')
@include('hutang.form_bayar')
@include('hutang.add_bayar')

@endsection

@section('script')
<script type="text/javascript">
var table, save_method;
var idprj=0;

listdata(idprj);

function listdata(idprj){
    table = $('#tblhutang').DataTable({
        "processing" : true,
        "lengthMenu": [[8, 25, 50, -1], [8, 25, 50, "All"]],       //pilihan jumlah record show
        "order" : [0,'DESC'],
        "destroy": true,
        //"dom"   : 'btp',
        "ajax" : {
            "url" : "hutang/"+idprj+"/data",
            "type" : "GET"
        }
    }); 
}   

$('#prj').on('change', function(){
    var id=$('#prj').val();
    listdata(id);
})

$('#ttl').on('change', function(){
    $('#bilang').text(formatAngka($('#ttl').val()));
})

//submit
$('#form-create').on("submit", function(e) {

    if(!e.isDefaultPrevented()){
		 
		$('#submit-control').html(' Simpan Create ... ');
		$('#submit-control').attr('disabled','disabled');
		  
        var id = $('#id').val();
        if(save_method == "add") { url = "{{ route('hutang.store') }}"; }
        else { url = "{{ DIR_APP }}hutang/"+id; }

        $.ajax({
            url : url,
            type : "POST",
            data : $('#form-create').serialize(),
            dataType: 'JSON',		   
            success : function(data){
			    if(data.msg=="error"){
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#prj').focus().select();
				}else{
					$('#modal-form_create').modal('hide');
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');		
					$('#tblhutang').DataTable().ajax.reload(null, false);
				}   
 		    },
            error : function(){
			    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			    $('#submit-control').html('Save');
			    $('#submit-control').removeAttr('disabled');			 
            }   
        });
        return false;
	}
});
   

function addForm(){
    
    var id=$('#prj').val();
    
    if(id=="0"){ alert('Harus Pilih Project dulu'); return false; }
    
    save_method = "add";
    $('input[name=_method]').val('POST');
    $('#modal-form_create').modal('show');
    $('#modal-form_create form')[0].reset();    
    $('#bilang').text('');
    tampilProject(id);
} 	 

function tampilProject(id){
    //var id=$('#prj').val();
    
    $.ajax({
        url : "{{ DIR_APP }}project/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            $('#id').val(id);
            $('#proj').val(data.project_name);
	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });      
}

function editdata(id){
    save_method = "edit";

    $('input[name=_method]').val('PATCH');
    $('#modal-form_create form')[0].reset();
    $.ajax({
        url : "{{ DIR_APP }}rumah/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            $('#modal-form_create').modal('show');
            
            tampilProject();
            
            $('#id').val(data.id);

            $('#clust').val(data.cluster);
            $('#blok').val(data.block);
            $('#nomor').val(data.nomor);
	        $('#harga').val(data.harga);
	        $('#dp').val(data.total_dp);
	        $('#tanah').val(data.luastanah);
	        $('#bangun').val(data.luasrumah);
	        $('#lantai').val(data.lantai);
	        $('#ket').val(data.deskripsi);
	        $('#ref').val(data.referensi);
	 
	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });   
}



function pembayaran(id){
    $('#modal-bayar').modal('show');
    $('#idtrx').val(id);
    $('#id2').val(id);
    tampilTransaksi(id);
    tampilDetail(id);
}


function tampilDetail(id){

    tblbayar.ajax.url("{{ DIR_APP }}hutang/"+id+"/databayar");
	tblbayar.ajax.reload();
}    

tblbayar = $('#tbl-bayar').DataTable({
    "scrollY": '55vh',
    "scrollCollapse": true,
    "bSort": false,
    "destroy": true,
    "processing" : true,
    "paging" : false,
    "dom" : 'bt',
});

function tampilTransaksi(id){
    $.ajax({
        url : "{{ DIR_APP }}hutang/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){

            $('#project').text(data.project_name);

            $('#hutang').text("HUTANG : IDR "+formatAngka(data.nominal));
	        $('#tlbayar').text("TOTAL BAYAR : IDR  "+formatAngka(data.pembayaran));
	        $('#sisa').text("SISA : IDR "+formatAngka(data.sisa));
	        $('#ketr').val(data.deskripsi);
	 
	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });       
}

/* cicilan */
function addBayar(){
    var id=$('#idtrx').val();
    
    save_method = "add";
    $('input[name=_method]').val('POST');
    $('#modal-addbayar').modal('show');
    $('#modal-addbayar form')[0].reset();     
    
    tampilInfo(id);
} 

function editKeterangan(id){
    
    var idhtg=$('#id2').val();
    
    save_method = "edit";
    $('input[name=_method]').val('PATCH');
    $('#modal-addbayar').modal('show');
    $('#modal-addbayar form')[0].reset();     
    
    $('#idbyr').val(id);
    tampilInfo(idhtg);
    tampilKeterangan(id);
    
}

function tampilInfo(id){
    
    $.ajax({
        url : "{{ DIR_APP }}hutang/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            $('#id2').val(id);
            $('#namaproject').val(data.project_name);
            $('#sisahutang').val(formatAngka(data.sisa))
	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });      
}

function tampilKeterangan(id){
    
    $.ajax({
        url : "{{ DIR_APP }}hutang/"+id+"/editketerangan",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            
            $('#tglbayar').val(data.tgl_bayar);
            $('#nom').val(data.nominal);
            $('#tpbayar').val(data.type_bayar);
            $('#ketrg').val(data.deskripsi);
	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });      
}

//submit
$('#form-addbayar').on("submit", function(e) {

    if(!e.isDefaultPrevented()){
        
        var id = $('#idbyr').val();	
        var id2= $('#id2').val();
        
        if(save_method == "add") { url = "{{ route('hutang.simpanbayar') }}"; tipe="POST"; }
        else { url="{{ DIR_APP }}hutang/"+id+"/simpanedit"; tipe="GET"; }

        $.ajax({
            url : url,
            type : tipe,
            data : $('#form-addbayar').serialize(),
            dataType: 'JSON',		   
            success : function(data){
			    if(data.msg=="error"){
					swal("WARNING", " Gagal menyimpan data !","error");

				}else{
					$('#modal-addbayar').modal('hide');
					$('#tbl-bayar').DataTable().ajax.reload(null, false);
					tampilTransaksi(id2);
				}   
 		    },
            error : function(){
			    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
		 
            }   
        });
        return false;
	}
});

function formatAngka(x) {
    x = x.toString();
    var pattern = /(-?\d+)(\d{3})/;
    while (pattern.test(x))
        x = x.replace(pattern, "$1.$2");
    return x;
}


</script>


@endsection
