<head>
    <style>
        #tbl-kasbon th, tr, td {border-bottom:1px black solid; border-top:1px black solid; }
    </style>
</head>

@extends('layouts.app')

@section('title')
  Data Kasbon
@endsection

@section('breadcrumb')
   @parent
   <li>kasbon</li>
@endsection

@section('content')     

<div class="row">
  <div class="container">
    <div class="card">
      <div class="card-block">     
    
    <h6>Data Kasbon </h6>
    
    <table class="table table-striped table-padding table-responsive" id="tbl-kasbon" width="100%">
        <thead>
            <tr class="tblheader">
                <th width="2%">NIP</th> 
                <th width="35%">Nama</th>
                <th width="15%">Jabatan</th>
                <th width="10%">Total Kasbon</th>
                <th width="5%">Act</th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>

      </div>
    </div>
  </div>
</div>

@include('kasbon.form_kasbon');

@endsection


@section('script')
<script type="text/javascript">
var table, save_method;

$(function(){
    table = $('.table').DataTable({
        "processing" : true,
        "lengthMenu": [[8, 15, 50, -1], [8, 15, 50, "All"]],       //pilihan jumlah record show
        "ajax" : {
            "url" : "{{ route('kasbon.datakasbon') }}",
            "type" : "GET"
        }
    }); 
})

function listkasbon(id){
   
   $('input[name=_method]').val('POST');
   $('#modal-kasbon').modal('show');
   $('#modal-kasbon form')[0].reset();            
   
   tampilDetail(id);
   
}

    tblkasbon = $('#tblkasbon').DataTable({
        "scrollY": '50vh',
        "scrollCollapse": true,
        "bSort": false,
        "destroy": true,
        "processing" : true,
	    "paging" : false,
	    "dom" : 'bti',
    });
    
function tampilDetail(id){

    tblkasbon.ajax.url("{{ DIR_APP }}kasbon/"+id+"/datadetail");
	tblkasbon.ajax.reload();
}  


</script>

@endsection