<head>
    <style>
        #tblpenjualan th, tr, td {
            border-bottom:1px black solid; border-top:1px black solid;
        }        
    </style>
</head>

@extends('layouts.app')

@section('title')
	
@endsection

@section('breadcrumb')
   @parent
   <li>Unposting Faktur Penjualan</li>
@endsection


@section('content')   
<div class="row">
	<div class="container-fluid">
		<div class="card">
			<div class="card-block">  

<h5>Unposting Faktur Penjualan</h5>			

<table class="table table-padding table-striped" id="tblpenjualan" width="100%">
<thead>
   <tr class="tblheader">
   
        <th width="115px">No.Faktur</th>
        <th width="30">GDG</th>
        <th width="50px">Tgl.Faktur</th>
        <th width="50px">Jt.Tempo</th>
        <th>Customer</th>
        <th width="100px">Sales</th>
        <th width="25px">Disc</th>
        <th width="25px">PPN</th>
        <th width="100px">Total</th>
        <th width="25px">Action</th>
 
	</tr>
</thead>
<tbody></tbody>

</table>


			</div>
		</div>
	</div>	
</div>

@include('sales.form_detail')

@endsection

@section('script')
<script type="text/javascript">
var table, save_method;

$(function(){
    table = $('#tblpenjualan').DataTable({
        "processing" : true,
        "lengthMenu": [[8, 25, 50, -1], [8, 25, 50, "All"]],       //pilihan jumlah record show
        "order" : [0,'DESC'],
        "ajax" : {
            "url" : "{{ route('sales.unpost_faktur') }}",
            "type" : "GET"
        }
    }); 
});   

function unpost(id){

    swal({
        title: "Anda Yakin ingin un-posting Faktur ini ?",
        text: "",
        icon: "info",
        buttons: [
            'Batal',
            'Unpost'
            ],
        dangerMode: true,
        }).then(function(isConfirm) {
        if (isConfirm) {
            swal({
                title: 'Confirm!',
                text: 'Klik OK untuk melanjutkan un-posting !',
                icon: 'info'
            }).then(function() {
                unposting_Ftr(id);
            });
        }else {
            swal("Batal", "Faktur Penjualan batal diunposting :)", "error");
        }
    })
}    

function unposting_Ftr(id){
    
    $.ajax({
        url : "{{ DIR_APP }}sales/"+id+"/unposted",
        type : "GET",
        //data : $('#form-detailfaktur').serialize(),
        dataType: 'JSON',		   
        success : function(data){
		    if(data.msg=="error"){
				swal("WARNING", " Gagal unposting data !","error");
				
			}else{
                swal("Success", "Faktur berhasil di-unposting !", "success");
                location.reload();
			}   
	    },
        error : function(){
		    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
        }   
    });
    return false;
}



</script>


@endsection
