@extends('layouts.app')

@section('title')
@endsection

@section('breadcrumb')
   @parent
   <li>Sales Order</li>
@endsection

@section('content')   

<form method="post" id="form-purchase">
{{ csrf_field() }}

<div class="row">
  <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
    <div class="card">
      <div class="card-block">   


<div class="text-left">
	{{ tanggal_indonesia(date('Y-m-d'),false) }}
</div>	


<table class="table table-striped table-padding table-bordered table-hover table-responsive" id="tbl-order" width="100%">
<thead>
   <tr class="tblheader">
   
 	    <th>NO.</th>	  
 	    <th width="15%">SALES</th>
        <th width="15%">NO.ORDER</th>
        <th width="35%">Customer</th>
	    <th width="10%">Disc</th>
	    <th width="20%">TOTAL</th>
        <th width="5%">Opsi</th> 	  
 
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

			</div>
		</div>
	</div>	
</div>


@endsection

@section('script')
<script type="text/javascript">
var table, save_method;
$(function(){
   table = $('.table').DataTable({
     "processing" : true,
     "ajax" : {
       "url" : "{{ route('order.order_sales') }}",
       "type" : "GET"
     }
   }); 
   
//submit
	  $(document).on("submit", function(e) {
      if(!e.isDefaultPrevented()){
		 
		 $('#submit-control').html(' Simapan Invoice ... ');
		 $('#submit-control').attr('disabled','disabled');
		  
         var id = $('#id').val();
         if(save_method == "add") url = "{{ route('invoice.store') }}";
         else url = "invoice/"+id;

         $.ajax({
           url : url,
           type : "POST",
           data : $('#modal-form_create form').serialize(),
           dataType: 'JSON',		   
           success : function(data){
			 if(data.msg=="discerror")
			 {
				 swal("WARNING", " Discount Tambahan invalid !","error");
					$('#dis').focus().select();
							$('#submit-control').html('Save');
							$('#submit-control').removeAttr('disabled');
			 }else{
				 if(data.msg=="error"){
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#supl').focus().select();
				 }else{
					$('#modal-form_create').modal('hide');
					swal("SUCCESS", " PO baru berhasil dicreate ! ","success");
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');					
					table.ajax.reload();
				 }   
		   }
 		   },
           error : function(){
             //alert("Tidak dapat menyimpan data!");
			 swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			 $('#submit-control').html('Save');
			 $('#submit-control').removeAttr('disabled');			 
           }   
         });
         return false;
	 }
   });
});


function tampilOrder(id){
    
}

</script>

@endsection
