@extends('layouts.app')
<head>
    <style>
        #tblhutang th { height:35px; background-color:#6495ED; color: white; font-size: 14px;}
        
        #tblhutang td,tr { font-size:13px; border:0px gray solid;
            border-bottom:1px gray solid; 
        }
        
    </style>
</head>

@section('title')

@endsection

@section('breadcrumb')
   @parent
   <li>Pelunasan Faktur Penjualan</li>
@endsection


@section('content')   
<div class="row">
	<div class="container-fluid">
		<div class="card">
			<div class="card-block">  

<h6>History Pelunasan Invoice</h6>

<div class="row">
    <div class="col-sm-6 col-md-5">
        <div class="form-group">
            <label>Project</label>
            <select type="text" id="gdg" name="gdg" autofoucs class="form-control" required>
                <option value="0"> --- ALL Project ---</option>
                @foreach($gdg as $list)
                    <option value="{{ $list->id }}">{{ $list->nama.' ['.$list->kode.']' }}</option>
                @endforeach
            </select>
        </div>    
    </div>
    
    <div class="col-sm-3 col-md-3">
		<label>Tgl.Lunas</label>
		<input id="awal" type="date" class="form-control" name="awal" value="{{ date('Y-m-d', strtotime("-60 day", strtotime(date('Y-m-d')))) }}" autofocus required>
    </div>
	<div class="col-sm-3 col-md-3">	
	    <label>Tgl.Akhir</label>
		<input id="akhir" type="date" class="form-control" name="akhir" value="{{ date('Y-m-d') }}" autofocus required>
    </div>
	<div class="col-md-1"> 
        <label></label>
		<button type="button" class="btn btn-primary btn-sm pull-right" onclick="showData()" style=margin-top:20px;><i class="fa fa-table"></i> View </button>
    </div>
</div>


<table class="table table-striped table-padding table-bordered table-responsive" id="tblhutang" width="100%">    
<thead>
   <tr class="tblhdr">
   
  	    <th width="10%">Tg.Invoice</th>
 	    <th width="10%">No.Invoice</th>
 	    <th width="35%">Supplier</th>
 	    <th width="10%">J.Tempo</th>
		<th width="12%" class="text-right">Total</th>
		<th width="1%">LNS</th>
		<th width="8%">No.Pelunasan</th>
		<th>Project</th>
		<th width="8px"></th> 
	</tr>
</thead>
<tbody></tbody>

</table>


        </div>

		</div>
	</div>	
</div>

@include('pelunasan.info_lunas')

@endsection

@section('script')
<script type="text/javascript">
var table;


function showData(){
    
    var gdg  = $('#gdg').val();
    var tgl1 = $('#awal').val();
    var tgl2 = $('#akhir').val();

    $(document).ready(function(){
        table = $('#tblhutang').DataTable({
            "processing" : true,
            "bSort": false,
            "destroy": true,
            "dom" : "bftip",
            "lengthMenu": [[8, 10, 20, -1], [10, 10, 20, "All"]],
            "order": [0, 'desc'],
            "ajax" : {
                "url" : "{{ DIR_APP }}pelunasan/"+gdg+"/"+tgl1+"/"+tgl2+"/history",
                "type" : "GET"
            }
        })
   }); 
}

function infopelunasan(id){

    $('#modal-info').modal('show');
    tblinfo.ajax.url("{{ DIR_APP }}pelunasan/"+id+"/infopelunasan");
	tblinfo.ajax.reload();
	
    tbldetail.ajax.url("{{ DIR_APP }}invoice/"+id+"/datadetail");
	tbldetail.ajax.reload();
}

tblinfo = $('#tbl-info').DataTable({
    "scrollY": '55vh',
    "scrollCollapse": true,
    "bSort": false,
    "destroy": true,
    "processing" : true,
    "paging" : false,
    "dom" : 'bt',
});
	 
tbldetail = $('#tbldetail').DataTable({
    "scrollY": '25vh',
    "scrollCollapse": true,
    "bSort": false,
    "destroy": true,
    "processing" : true,
	"paging" : false,
	"dom" : 'bti',    
})


</script>

@endsection
