@extends('layouts.myform2')

@section('title')
  Daftar Supplier -> PriceList
  		<a onclick="window.location='{{ route('home') }}'" class="btn btn-warning"><i class="fa fa-home"></i> Home </a>	
@endsection

@section('breadcrumb')
   @parent
   <li>supplier</li>
@endsection

@section('content')     
<div class="row">
  <div class="col-xs-12">
    <div class="box">
      <div class="box-header">
      </div>
      <div class="box-body">  

<table class="table table-striped">
<thead>
   <tr class="info">
      <th width="40">KODE</th>
      <th>Nama Supplier</th>
      <th>Alamat</th>
      <th>Kota</th>
      <th width="50">Pilih</th>
   </tr>
</thead>
<tbody></tbody>
</table>

      </div>
    </div>
  </div>
</div>

@endsection

@section('script')
<script type="text/javascript">
var table, save_method;
$(function(){
   table = $('.table').DataTable({
     "processing" : true,
     "ajax" : {
       "url" : "{{ route('supplier.pilihdata') }}",
       "type" : "GET"
     }
   }); 
   
function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('PATCH');
   $('#modal-form form')[0].reset();
   $.ajax({
     url : "supplier/"+id+"/edit",
     type : "GET",
     dataType : "JSON",
     success : function(data){
       $('#modal-form').modal('show');
       $('.modal-title').text('Edit Supplier');
       
       $('#id').val(data.id_supp);
	   $('#kode').val(data.sup_id).attr('readonly', true);
       $('#nama').val(data.sup_nama);
       $('#alamat').val(data.sup_alamat);
       $('#telpon').val(data.sup_telp);
	   $('#kota').val(data.sup_kota);
       
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}

function tampilData($id){
	}

});

</script>
@endsection