<!DOCTYPE html>
@extends('layouts.app')

@section('title')
  Pilih Barang / SKU
@endsection

@section('breadcrumb')
   @parent
   <li>pilih barang</li>
@endsection

@section('content') 

<html> 

<head>
	
	<script src="{{ asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/bootstrap/js/bootstrap.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js') }}"></script>
	<script src="{{ asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js') }}"></script>
	<script type="text/javascript" src="public/adminLTE/dist/css/sweetalert.min.js"></script>
	
</head>

 
 <body>

  <div class="container box">

    <div class="panel-heading"></div> 
	<a onclick="window.history.back()" class="btn btn-warning"><i class="fa fa-undo"></i> Back </a> 
    <div class="form-group"> 
    
	<form id="myForm">	
	   <input type="text" name="search" id="search" class="form-input" autofocus autocomplete="off" placeholder=" input SKU ... "/>
	   <input type="button" value=" Reset " onclick="myFunction()">
	   
	</form>    
	
	</div>

<!-- script untuk reset -->
<script>
function myFunction() {
  document.getElementById("myForm").reset();
  document.getElementById("search").focus();	//kembali ke focus jika clik reset
}
</script>

    <table class="table table-striped table-bordered" id="tabel">	
       <thead>
        <tr>
 		 <th>SKU</th>
         <th>DESKRPSI</th>
		 <th>Pilih.</th>
        </tr>
       </thead>
       
      <tbody></tbody>

    </table>
       
  </div>
  
 </body>

</html>

@endsection

@section('script')
 
<script type="text/javascript">
$(document).ready(function(){

       $("#search").keypress(function(e){
            if(e.which == 13)
			{
                e.preventDefault();
                fetch_data();
            }else if($(this).val().length > 2){
               fetch_data();				
            }
        });
 
 function fetch_data(query = '')
 {
  $.ajax({
   url:"{{ route('pilihproduct.action') }}",
   method:'GET',
   data:{query:query},
   dataType:'json',
   success:function(data)
   {
	   if (data.sku_kode=="")
		{
			alert('tidak ada !');
			//swal("WARNING", " SKU ini tidak ada, coba periksa lagi !","warning");
		}
	   
	var newRows;
	{
	 newRows += "<tr><td>" + data.sku_kode + "</td>"
	 newRows += "<td>"     + data.sku_name + "</td>"
	 newRows += "<td>"     + data.pilih    + "</td></tr>"
	}
    
	$('tbody').html(newRows);
    
	}
  })
 }
 
 $(document).on('keyup', '#search', function(event){
  //jika enter baru cari data, not livesearch
  if (event.key == 'Enter')
  {
	var query = $(this).val();
	fetch_data(query);
  }else{
	  if (event.key == "Escape")						//jika escape akan reset
	  {
		document.getElementById("myForm").reset();
		document.getElementById("search").focus();		//kembali ke focus jika clik reset
		$("#tabel tbody > tr").remove();				//membersihkan tabel
	  }
  }
 });
 
});
</script>

@endsection