<head>
    <style>
        #tblretur th, tr, td {
            border-bottom:1px black solid; border-top:1px black solid;
        }        
    </style>
</head>

@extends('layouts.app')

@section('title')
	
@endsection

@section('breadcrumb')
   @parent
   <li>Retur Penjualan</li>
@endsection


@section('content')   
<div class="row">
	<div class="container-fluid">
		<div class="card">
			<div class="card-block">  
			

<form method="post" id="form-penjualan">
{{ csrf_field() }}

<h6>Retur Penjualan</h6>

<table class="table table-padding table-striped" id="tblretur" width="100%">
<thead>
   <tr class="tblheader">
   
        <th width="100px">No.Retur</th>
        <th width="70px">Tanggal</th>
        <th>Customer</th>
        <th width="75px">Sales</th>
        <th width="70px">Total</th>
        <th width="5px">Act</th>
 
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

			</div>
		</div>
	</div>	
</div>

@include('retur.form_detail')

@endsection

@section('script')
<script type="text/javascript">
var table, save_method;

$(function(){
    table = $('#tblretur').DataTable({
        "processing" : true,
        "lengthMenu": [[8, 25, 50, -1], [8, 25, 50, "All"]],       //pilihan jumlah record show
        "order" : [0,'DESC'],
        "ajax" : {
            "url" : "{{ route('retur.history') }}",
            "type" : "GET"
        }
    }); 
});   



function showDetail(id){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#form-detail').modal('show');
   $('#form-detail form')[0].reset();   
   tampilHeader(id);
   tampilDetail(id);
   loadSummary();
}

function tampilHeader(id){
    $('#idretur').val(id);
    $('#idretur2').val(id);    
    $.ajax({
        url : "{{ DIR_APP }}retur/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            
            $('#cust').text(data.cus_name+" - "+data.cus_address);
            $('#nofaktur').text("NO.Retur: "+data.rtr_no);

	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });   
}

function tampilCustomer(){
    
    var id=$('#idretur').val();
   
    $.ajax({
        url : "{{ DIR_APP }}retur/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            
            $('#idcust').val(data.id_cust);
            $('#idsale2').val(data.id);

	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });   
}


function loadSummary(){
    
    var id=$('#idretur').val();
    
    $.ajax({
        url : "{{ DIR_APP }}retur/"+id+"/loadsummary",
        type : "GET",
        dataType : "JSON",
        success : function(data){

            $('#totalftr').text("Total Retur : \xa0\xa0\xa0"+data.totalftr);

	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });   
}

    tbdetail = $('#tbldetail').DataTable({
        "scrollY": '55vh',
        "scrollCollapse": true,
        "bSort": false,
        "destroy": true,
        "processing" : true,
	    "paging" : false,
	    "dom" : 'bti',
    });
    
function tampilDetail(id){

    tbdetail.ajax.url("{{ DIR_APP }}retur/"+id+"/historydetail");
	tbdetail.ajax.reload();
}    


function printFaktur(){
    var id = $('#idretur').val();
    window.location="{{ DIR_APP }}retur/"+id+"/printfaktur";
}


</script>


@endsection
