<head>
    <style>
        #tblrumah th, tr, td {
            border-bottom:1px black solid; border-top:1px black solid;
        }   
        
        #tbl-info th, tr, td {
            border-bottom:1px black solid; border-top:1px black solid;
        } 
        
    </style>
</head>

@extends('layouts.app')

@section('title')

@endsection

@section('breadcrumb')
   @parent
   <li>Project Perumahan</li>
@endsection


@section('content')   
<div class="row">
	<div class="container-fluid">
		<div class="card">
			<div class="card-block">  
			
    <a onclick="addForm()" class="btn btn-success btn-sm pull-right"><i class="fa fa-plus-circle"> </i> New Rumah </a> 			
    
    <input type="hidden" id="hargarumah" name="hargarumah">
    
<form method="post" id="form-project">
{{ csrf_field() }}

        <div class="form-group col-sm-6 col-md-6">
            <label>Project Perumahan</label>
            <select type="text" id="project" name="project" autofoucs class="form-control" style="font-weight:bold">
                @foreach($prj as $list)
                    <option value="{{ $list->id }}">{{ $list->project_name.' ['.$list->initial.']' }}</option>
                @endforeach
            </select>
        </div>        

    <h6>CK=CASH KERAS - CB=CASH BERTAHAP</h6>

<table class="table table-padding table-striped table-responsive" id="tblrumah" width="100%">
<thead>
   <tr class="tblheader">
   
        <th width="300px">Perumahan</th>
        <th width="30px">Cluster</th>
        <th width="15px">Blok</th>
        <th width="15px">Nomor</th>
        <th width="75px">Type</th>
        <!--th width="10px">Lt</th-->
        <th width="100px">Harga</th>
        <th width="100px">Status</th>
        <th width="250px">Deskripsi</th>
        <th width="30px">Act</th>
 
	</tr>
</thead>
<tbody></tbody>

</table>
</form>

			</div>
		</div>
	</div>	
</div>

@include('rumah.form_create')
@include('rumah.info_rumah')
@include('rumah.form_termin')

@endsection

@section('script')
<script type="text/javascript">
var table, save_method;
var idprj=1;

listrumah(idprj);

function listrumah(idprj){
    table = $('#tblrumah').DataTable({
        "processing" : true,
        "lengthMenu": [[8, 25, 50, -1], [8, 25, 50, "All"]],       //pilihan jumlah record show
        "order" : [0,'DESC'],
        "destroy": true,
        //"dom"   : 'btp',
        "ajax" : {
            "url" : "rumah/"+idprj+"/datarumah",
            "type" : "GET"
        }
    }); 
}   

$('#project').on('change', function(){
    var id=$('#project').val();
    listrumah(id);
})

//submit
$('#form-create').on("submit", function(e) {

    if(!e.isDefaultPrevented()){
		 
		$('#submit-control').html(' Simpan Create ... ');
		$('#submit-control').attr('disabled','disabled');
		  
        var id = $('#id').val();
        if(save_method == "add") { url = "{{ route('rumah.store') }}"; }
        else { url = "{{ DIR_APP }}rumah/"+id; }

        $.ajax({
            url : url,
            type : "POST",
            data : $('#form-create').serialize(),
            dataType: 'JSON',		   
            success : function(data){
			    if(data.msg=="error"){
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#prj').focus().select();
				}else{
					$('#modal-form_create').modal('hide');
					$('#submit-control').html('Save');
					$('#submit-control').removeAttr('disabled');		
					$('#tblrumah').DataTable().ajax.reload(null, false);
				}   
 		    },
            error : function(){
			    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			    $('#submit-control').html('Save');
			    $('#submit-control').removeAttr('disabled');			 
            }   
        });
        return false;
	}
});
   

function addForm(){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#modal-form_create').modal('show');
   $('#modal-form_create form')[0].reset();    
   
   tampilProject();
} 	 

function tampilProject(){
    var id=$('#project').val();
    $.ajax({
        url : "{{ DIR_APP }}project/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            $('#id_project').val(id);
            $('.modal-title').text(data.project_name);
	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });      
}

function editRumah(id){
    save_method = "edit";

    $('input[name=_method]').val('PATCH');
    $('#modal-form_create form')[0].reset();
    $.ajax({
        url : "{{ DIR_APP }}rumah/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            $('#modal-form_create').modal('show');
            
            tampilProject();
            
            $('#id').val(data.id);

            $('#clust').val(data.cluster);
            $('#blok').val(data.block);
            $('#nomor').val(data.nomor);
	        $('#harga').val(data.harga);
	        $('#dp').val(data.total_dp);
	        $('#tanah').val(data.luastanah);
	        $('#bangun').val(data.luasrumah);
	        $('#lantai').val(data.lantai);
	        $('#ket').val(data.deskripsi);
	        $('#ref').val(data.referensi);
	 
	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });   
}


function addDetail(id){
   save_method = "add";
   $('input[name=_method]').val('POST');
   $('#form-detail').modal('show');
   $('#form-detail form')[0].reset();   
   tampilHeader(id);
   tampilDetail(id);
   loadSummary();
}

function tampilHeader(id){
    $('#idsale').val(id);
    $('#idsale2').val(id);    
    $('#idsale3').val(id);
    $.ajax({
        url : "{{ DIR_APP }}sales/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            
            $('#cust').text(data.cus_name+" - "+data.cus_address);
            $('#nofaktur').text("NO.Faktur: "+data.sale_no);
            $('#keterangan').text("Disc Faktur: "+data.sale_disc+"%"+'\xa0\xa0\xa0\xa0\xa0\xa0\xa0'+"PPN: "+data.sale_ppn+"%");

	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });   
}

function tampilCustomer(){
    
    var id=$('#idsale').val();
   
    $.ajax({
        url : "{{ DIR_APP }}sales/"+id+"/edit",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            
            $('#idcust').val(data.id_cust);
            $('#idsale2').val(data.id);

	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });   
}



    tbdetail = $('#tbldetail').DataTable({
        "scrollY": '55vh',
        "scrollCollapse": true,
        "bSort": false,
        "destroy": true,
        "processing" : true,
	    "paging" : false,
	    "dom" : 'bti',
    });
    
function tampilDetail(id){

    tbdetail.ajax.url("{{ DIR_APP }}sales/"+id+"/datadetail");
	tbdetail.ajax.reload();
}    

function tampil_Detail(id){
    tbldetail = $('#tbldetail').DataTable({
        "processing" : true,
        "lengthMenu": [[8, 25, 50, -1], [8, 25, 50, "All"]],       //pilihan jumlah record show
        "ajax" : {
            "url" : "{{ DIR_APP }}sales/"+id+"/datadetail",
            "type" : "GET"
        }
    });     
}

function addItem(){
    save_method = "add";
    $('input[name=_method]').val('POST');
    $('#add_detail').modal('show');
    $('#add_detail form')[0].reset();   
    $('#prd2').removeAttr('disabled');
    tampilCustomer();
    
}

 	tblkemasan = $('.tabel-kemasan').DataTable({
        "bSort": false,
        "destroy": true,
        "processing" : true,
	    "paging" : false,
	    "dom" : 'bt',
    });
    
 	tblcustomer = $('.tabel-customer').DataTable({
        "bSort": false,
        "destroy": true,
        "processing" : true,
	    "paging" : false,
	    "dom" : 'bt',
    });
    
//submit add detail -> sama degn sales
$('#form-add_detail').validator().on("submit", function(e) {

    if(!e.isDefaultPrevented()){
		 
		$('#submit-add').html(' Simpan data ... ');
		$('#submit-add').attr('disabled','disabled');
		  
        var id = $('#iddetail').val();
        if(save_method == "add") { url = "{{ DIR_APP }}sales/adddetail"; tipe="POST"; }
        else { url = "{{ DIR_APP }}sales/"+id+"/simpanedit" ; tipe="GET"; }

        $.ajax({
            url : url,
            type : tipe,
            data : $('#form-add_detail').serialize(),
            dataType: 'JSON',		   
            success : function(data){
			    if(data.msg=="error"){
					$('#submit-detail').html('Save');
					$('#submit-detail').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan data !","error");
					$('#prd').focus().select();
					return false;
			    }
			    
			    if(data.msg=="error2"){
					swal("WARNING", " Invalid Kemasan  !","error");
					$('#prd').focus().select();
					return false;				    
			    }
			    
				if(data.msg=="error1"){
					swal("WARNING", " Stock tidak ada/ Tidak mencukupi !","error");
					$('#prd').focus().select();
					return false;				    
			
				}else{

					$('#add_detail').modal('hide');
					$('#submit-detail').html('Save');
					$('#submit-detail').removeAttr('disabled');		
					loadSummary();					
					$("#tbldetail").DataTable().ajax.reload(null, false);
					$('#tblpenjualan').DataTable().ajax.reload(null, false);

				}   
 		    },
            error : function(){
			    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			    $('#submit-detail').html('Save');
			    $('#submit-detail').removeAttr('disabled');			 
            }   
        });
        return false;
	}
});
   
function infoRumah(id){

    $('#modal-inforumah').modal('show');


    $.ajax({
        url : "{{ DIR_APP }}rumah/"+id+"/inforumah",
        type : "GET",
        dataType : "JSON",
        success : function(data){

            $('.modal-title').text(data.project_name);
            
            $('#blok2').text(data.cluster+'/'+data.block+'/'+data.nomor);
            $('#harga2').text(formatAngka(data.harga_rumah));
	        $('#cust').text(data.cus_name);
	        $('#tgltrx').text(data.tgl_book);
	 
	    },
        error : function(){
            alert("Tidak dapat menampilkan data!");
        }
    });   
    
}

function formatAngka(x) {
    x = x.toString();
    var pattern = /(-?\d+)(\d{3})/;
    while (pattern.test(x))
        x = x.replace(pattern, "$1.$2");
    return x;
}

function displayunit(id){
    alert('display unit');
}

$('#harga').on('change', function(){
    var hg=$('#harga').val();
    $('#hgjual').val(formatAngka(hg));
})

/* termin */
function termin(id){
    $('#modal-termin').modal('show');
    $('#idrmh').val(id);
    tampilTransaksi(id);
    tampilDetail(id);
}

function tampilDetail(id){

    tbltermin.ajax.url("{{ DIR_APP }}transaksi/"+id+"/datatermin");
	tbltermin.ajax.reload();
}    

tbltermin = $('#tbl-termin').DataTable({
    "scrollY": '55vh',
    "scrollCollapse": true,
    "bSort": false,
    "destroy": true,
    "processing" : true,
    "paging" : false,
    "dom" : 'bt',
});

function tampilTransaksi(id){
    $.ajax({
        url : "{{ DIR_APP }}termin/"+id+"/datarumah",
        type : "GET",
        dataType : "JSON",
        success : function(data){

            $('#project2').text(data.project_name);
            $('#cus2').text(data.cus_name +' - '+ data.address);
            $('#block2').text("CLUSTER/BLOCK : "+data.cluster +'/'+data.block+'/'+data.nomor);
	        $('#hgrumah').text("HARGA  : IDR "+formatAngka(data.harga_rumah));
	        
	        $('#hargarumah').val(data.harga_rumah);

	    },
        error : function(){
            alert("Tidak dapat menampilkan data rumah!");
        }
    });       
}

/* add */
function addtermin(){
    var idrmh = $('#idrmh').val();
    
    save_method = "add";
    $('input[name=_method]').val('POST');
    $('#modal-addtermin').modal('show');
    $('#modal-addtermin form')[0].reset();     
    $('#idrmh2').val(idrmh);
} 

//submit
$('#form-addtermin').validator().on("submit", function(e) {

    if(!e.isDefaultPrevented()){
        
        var id = $('#idrmh2').val();		 
        if(save_method == "add") { url = "{{ route('termin.store') }}"; }

        $.ajax({
            url : url,
            type : "POST",
            data : $('#form-addtermin').serialize(),
            dataType: 'JSON',		   
            success : function(data){
			    if(data.msg=="error"){
					swal("WARNING", " Gagal menyimpan data !","error");

				}else{
					$('#modal-addtermin').modal('hide');
					$('#tbl-termin').DataTable().ajax.reload(null, false);
				}   
 		    },
            error : function(){
			    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
		 
            }   
        });
        return false;
	}
});


$('#persen').on('change', function(){
    var ttl = parseInt($('#hargarumah').val()) * parseInt($('#persen').val())/100;
    $('#nom').val(ttl);
})


</script>


@endsection
