<!DOCTYPE html>
<html>

<head>
    <style>
        #area th, tr, td {border-bottom:1px black solid; border-top:1px black solid; }
	</style>
</head>

@extends('layouts.app')


@section('breadcrumb')
   @parent
   <li>Brand</li>
@endsection


@section('content')   
<section id="tbl-data" class="show">

<div class="row">
  <div class="container">
    <div class="card">
       <div class="card-block">       

      <div class="text-left">
        <a onclick="addForm()" class="btn btn-outline-info btn-sm" style="margin-bottom:-30px"><i class="fa fa-plus-circle"></i> New Area </a>
      </div>

<table class="table table-striped table-hover" id="area" width="100%">
  <thead>
    <tr class="tblheader">       
        <th>Nama Area</th>
        <th width="5%">Action</th>
    </tr>
  </thead>
  <tbody></tbody>
</table>

      </div>
    </div>
  </div>
</div>
</section>

<!-----form input -----------------> 
<section id="form-data" class="hide">

<form class="form-horizontal" data-toggle="validator" method="post" id="form-input">
   {{ csrf_field() }} {{ method_field('POST') }}
   
   <div class="card" style="width:100%; margin:auto;">
     <div class="card-block">
        <h5>Form Area</h5>
  <br></br>
  <input type="hidden" id="id" name="id">
	
  <div class="form-group">
    <label for="nama" class="col-md-3 control-label">Nama Area</label>
    <div class="col-md-6">
      <input id="nama" type="text" class="form-control" name="nama" autofocus required autocomplete="off">
      <span class="help-block with-errors"></span>
    </div>
  </div>
   <br></br>

   <div class="card-body">
		  <button id="submit-control" type="submit" class="btn btn-outline-success"><i class="fa fa-floppy-o"></i> Simpan </button>
		  <button id="tutup" type="button" onclick="tutupForm()" class="btn btn-outline-warning"><i class="fa fa-times"></i> Close</button>
   </div>
    
    </div>
    </div>
   </form>

</section>

@endsection

@section('script')
<script type="text/javascript">
var  save_method;
$(document).ready(function() {

	var table = $('#area').DataTable ({
        "processing": true,
        "serverSide": true,
        "bsort": true,
        "pageLength" :8,
        "ajax": "{{ route('salesman.dataarea') }}",
        "columns":[
            { "data": "area_name" },
			      {
                "data": "id",
                "sClass": "text-center",
                "orderable": false,
                "mRender": function (data) {
                           return '<a onclick="editForm('+data+')" class="btn btn-outline-success btn-xs"><i class="fa fa-pencil"></i></a> ' 
                         }
            }
  			
        ]
     });
   
   $('#form-input').validator().on('submit', function(e){

      if(!e.isDefaultPrevented()){
		  $('#submit-control').html(' data sedang disimpan ... ');
		  $('#submit-control').attr('disabled','disabled');		  

      var id = $('#id').val();
      if(save_method == "add") url = "{{ route('salesman.simpanarea') }}";
      else url = "{{ DIR_APP }}salesman/"+id+"/simpaneditarea";
         
      $.ajax({
          url : url,
          type : "POST",
          data : $('#form-input').serialize(),
          success : function(data){

          if(data.msg =="error"){  
              swal("WARNING", " Area gagal disimpan ! ","error"); 
          }else{
              swal("SUCCESS", " Area berhasil disimpan ! ","success");
			        $('#submit-control').html('<i class="fa fa-floppy-o"></i> Save');
			        $('#submit-control').removeAttr('disabled');	
              tutupForm();
              $('#area').DataTable().ajax.reload();
            }
          },
          error : function(){
            $('#submit-control').html('<i class="fa fa-floppy-o"></i> Save');
			      $('#submit-control').removeAttr('disabled');
            alert("Tidak dapat menyimpan data!");
          }   
      });
         return false;
     }
	  
   });
   
});

function add_Form(){
	save_method = "add";
	$('input[name=_method]').val('POST');
	$('#modal-form').modal('show');
	$('#modal-form form')[0].reset();   

	$('.modal-title').text('New Brand');
}

function editForm(id){
   save_method = "edit";
   $('input[name=_method]').val('POST');
   $.ajax({
     url : "{{ DIR_APP }}salesman/"+id+"/editarea",
     type : "GET",
     dataType : "JSON",
     success : function(data){

       bukaForm();
       
       $('#id').val(data.id);
       $('#nama').val(data.area_name);
       
     },
     error : function(){
       alert("Tidak dapat menampilkan data!");
     }
   });
}

/* versi baru */

function addForm(){
	save_method="add";
  $('input[name=_method]').val('POST');

  $('#burger').click();
	$('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
	document.getElementById("form-input").reset();
}


function tutupForm(){
  $('#burger').click();
	$('#form-data').addClass("hide");
	$('#tbl-data').removeClass("hide");
	$('#tbl-data').addClass("show");	

  document.getElementById("form-input").reset();
}

function bukaForm(){
  $('#burger').click();
  $('#tbl-data').addClass("hide");
	$('#form-data').removeClass("hide");
	$('#form-data').addClass("show");
	document.getElementById("form-input").reset();
}

</script>
@endsection
</html>