<!DOCTYPE html>
<html>
@extends('layouts.app')

<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

	<!--
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/js/bootstrap.min.js"></script>
	
	<script type="text/javascript" src="/wawan/public/adminLTE/dist/css/sweetalert.min.js"></script>
	-->
	
	<style>
		    #tbl-stock th,tr,td { border-bottom: 1px black solid;}
		    
			.tbl_stn {
			    position:absolute;
				top: 110px;
				left: 240px;
				width: 355px;
				height: 520px;
			    //border: 1px solid #543535;
			}				

			.tbl_kms {
			    position:absolute;
				top: 110px;
				right: 10px;
				width: 730px;
				height: 520px;
				//border: 1px solid #543535;
			}	
			
			.wrap {
			  width: 50%;
			  display: inline-block;
			  margin: 10px;
			}
			
		
			.tblheader {
				background: #2F4F4F;
				color: white;
				font-size: 15px;
				alignment: center;
			}

	</style>


</head>

@section('breadcrumb')
    @parent
    <li>data stock</li>
@endsection

<!------------------>

@section('content')
<div class="row">
    
<form class="form-horizontal" data-toggle="validator" method="post" id="form-stock">
{{ csrf_field() }} {{ method_field('POST') }}
    
    <div class="container-fluid">
        <div class="card">
            <div class="card-block">
                
    <div class="row" style="margin-right:5px;">
        <div class="form-group col-sm-53 col-md-5" style="margin-left:5px;margin-right:5px;">
            <label>Gudang</label>
            <select type="text" id="gudang" name="gudang" autofoucs class="form-control">
                <!--option value="1">Pilih Gudang</option-->
                @foreach($gdg as $list)
                    <option value="{{ $list->id }}">{{ $list->kode."-".$list->nama }}</option>
                @endforeach
            </select>
        </div>        

        <div class="text-right">
            <a onclick="printformopname()" class="btn btn-success btn-sm"><i class="fa fa-print"></i> Print Form Opname</a>
            <a onclick="sisastock()" class="btn btn-info btn-sm"><i class="fa fa-print"></i> Print Sisa Stock</a>
        </div>
        
    </div>
            
    <table class="table table-striped table-padding" id="tbl-stock" width="100%" style="margin-top:-50px">
        <thead>
            <tr class="tblheader">
                <th width="30">GDG</th>
                <th>Deskripsi</th>
                <th>Category</th>
                <th>SATUAN</th>
        	    <th width="70">STOCK(Qty)</th>
                <th>Act</th> 	  
         	</tr>
        </thead>
        
        <tbody></tbody>	 
    
    </table>
    
            </div>
        </div>
    </div>
</form>

</div>

@endsection

@include('stock.detail')
@include('stock.form_adj')


<!-------------------------------->

@section('script')

<script type="text/javascript">
var table, tbl_stock, save_method;
    
idgudang="1";

showStock(idgudang);

function showStock(id){
    
	jQuery(document).ready(function($){
	table = $('#tbl-stock').DataTable({
        "processing" : true,
        "lengthMenu": [[8, 25, 50, -1], [8, 25, 50, "All"]],
	    "destroy" : true,
	    "dom" : 'btip',	 
        "ajax" : {
            "url" : "stock/"+id+"/listdata",
            "type" : "GET"
            }
        });
    });
}

$('#gudang').on('change', function(){
    var id=$('#gudang').val();
    
    showStock(id);
})

	tblrekap = $('#tabel-rekap').DataTable({
        "bSort": false,
        "destroy": true,
        "processing" : true,
		"paging" : false,
    	"dom" : 'bt',
    });
    
	tblouts = $('#tabel-outstanding').DataTable({
        "bSort": false,
        "destroy": true,
        "processing" : true,
		"paging" : false,
    	"dom" : 'bt',
    });    
    
	tblmasuk = $('#tabel-masuk').DataTable({
        "bSort": false,
        "destroy": true,
        "scrollY": '15vh',
        "scrollCollapse": true,        
        "processing" : true,
		"paging" : false,
		"order" :[['0','DESC']],
    	"dom" : 'bti',
    });    
    
    tblout = $('#tabel-keluar').DataTable({
        "bSort": false,
        "destroy": true,
        "scrollY": '18vh',
        "scrollCollapse": true,        
        "processing" : true,
		"paging" : false,
		"order" :[['0','DESC']],
    	"dom" : 'bti',
    });	
    
    tblretur = $('#tabel-retur').DataTable({
        "bSort": false,
        "destroy": true,
        "scrollY": '15vh',
        "scrollCollapse": true,        
        "processing" : true,
		"paging" : false,
		"order" :[['0','DESC']],
    	"dom" : 'bti',
    });	    
 
function showDetail(id){
    
    //alert('show '+id); return false;
	
    $('#modal-detail').modal('show');
	
	tampilProduk(id);
	
    tblrekap.ajax.url("stock/"+id+"/stockrekap");
	tblrekap.ajax.reload();
	
    //tblouts.ajax.url("stock/"+id+"/cekoutstanding");
	//tblouts.ajax.reload();

    tblmasuk.ajax.url("stock/"+id+"/stockmasuk");
	tblmasuk.ajax.reload();
	
    tblout.ajax.url("stock/"+id+"/stockkeluar");
	tblout.ajax.reload();

    tblretur.ajax.url("stock/"+id+"/stockretur");
	tblretur.ajax.reload();

}

function tampilProduk(id){
    
    $('#idstock').val(id);
    $('#idadj').val(id);
    
    $.ajax({
        url : "{{ DIR_APP }}stock/"+id+"/tampilproduk",
        type : "GET",
        dataType : "JSON",
        success: function(data){
            $('#namaproduk').text(data.nama_brg);
            $('#namaadj').text(data.nama_brg);
        },
        error: function(){
            alert('gagal menampilkaa data');
        }
    });
}

function tampilStock(id){
    
    $.ajax({
        url : "{{ DIR_APP }}stock/"+id+"/tampilstock",
        type : "GET",
        dataType : "JSON",
        success: function(data){
            $('#stock').val(data.stock);
            
        },
        error: function(){
            alert('gagal menampilkaa data');
        }
    });
}

function printformopname(){
    var gdg = $('#gudang').val();
    window.location="{{ DIR_APP }}stock/"+gdg+"/printform";
}

function printfor_mopname(){
        
    var gdg = $('#gudang').val();
        
    var ua = navigator.userAgent.toLowerCase();
    var isAndroid = ua.indexOf("android") > -1; //&& ua.indexOf("mobile");
                	
    if(isAndroid) {
        var tpdevice='android';
    }else{
        var tpdevice='pclaptop';
    }
            
    $.ajax({
        url : "{{ DIR_APP }}stock/"+gdg+"/printform",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            if(tpdevice=='android'){
                window.location.href=data.data;
            }else{
            	var socket = new WebSocket("ws://127.0.0.1:40213/");        /* harus dijalankan dulu dari rawbt.bat */
                socket.bufferType = "arraybuffer";
                socket.onerror = function(error) {
            	    alert("Error");
                };			
            	socket.onopen = function() {
            		socket.send(data.data);
            		socket.close(1000, "Work complete");
            	};                    
            }
        },
        error : function(){
            alert("error print...");
        }
    });
}


function kartuStock(){
    
    alert('belum siap ');
    return false;
    
    var id=$('#idstock').val();
    var tgl1=$('#awal').val();
    var tgl2=$('#akhir').val();

    var ua = navigator.userAgent.toLowerCase();
    var isAndroid = ua.indexOf("android") > -1; //&& ua.indexOf("mobile");
                	
    if(isAndroid) {
        var tpdevice='android';
    }else{
        var tpdevice='pclaptop';
    }
            
    $.ajax({
        url : "{{ DIR_APP }}stock/"+id+"/"+tgl1+"/"+tgl2+"/kartustock",
        type : "GET",
        dataType : "JSON",
        success : function(data){
            if(tpdevice=='android'){
                window.location.href=data.data;
            }else{
            	var socket = new WebSocket("ws://127.0.0.1:40213/");        /* harus dijalankan dulu dari rawbt.bat */
                socket.bufferType = "arraybuffer";
                socket.onerror = function(error) {
            	    alert("Error");
                };			
            	socket.onopen = function() {
            		socket.send(data.data);
            		socket.close(1000, "Work complete");
            	};                    
            }
        },
        error : function(){
            alert("error print...");
        }
    });    
}

function sisastock(){
    
    var gdg = $('#gudang').val();

    $('#form-stock').attr('action', "{{ DIR_APP }}stock/"+gdg+"/reportstock").submit();       //--> open new windows
    //location.reload();
}


function adjust(id){
    
    //return false;
    
    $('#modal-adjust').modal('show');
	$('#modal-adjust form')[0].reset(); 
	$('input[name=_method]').val('POST');
	
	tampilProduk(id);
	tampilStock(id);
}

//submit
$('#form-adjust').on("submit", function(e) {

    if(!e.isDefaultPrevented()){
		 
		$('#submit-adj').html(' Simpan Create ... ');
		$('#submit-adj').attr('disabled','disabled');
		  
        url = "{{ DIR_APP }}stock/simpanadjust";

        $.ajax({
            url : url,
            type : "POST",
            data : $('#form-adjust').serialize(),
            dataType: 'JSON',		   
            success : function(data){
			    if(data.msg=="error"){
					$('#submit-adj').html('Save');
					$('#submit-adj').removeAttr('disabled');
					swal("WARNING", " Gagal menyimpan adjustment !","error");
					$('#koreksi').focus().select();
				}else{
					$('#modal-adjust').modal('hide');
				
					$('#submit-adj').html('Save');
					$('#submit-adj').removeAttr('disabled');		
					$('#tbl-stock').DataTable().ajax.reload(null, false);
				}   
 		    },
            error : function(){
			    swal("WARNING"," DATA tidak dapat disimpan, harap hubungi IT !","error");
			    $('#submit-adj').html('Save');
			    $('#submit-adj').removeAttr('disabled');			 
            }   
        });
        return false;
	}
});

</script>

@endsection
</html>