<!DOCTYPE html>

<html lang="<?php echo e(config('app.locale')); ?>">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo e(config('app.name', 'MyProject')); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    
      
    <link rel="stylesheet" href="<?php echo e(asset('public/adminLTE/bootstrap/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/font-awesome/css/font-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/adminLTE/dist/css/AdminLTE.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/adminLTE/dist/css/skins/skin-black-light.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/adminLTE/plugins/datepicker/datepicker3.css')); ?>">
    
      
    <script type="text/javascript" src="<?php echo e(DIR_APP); ?>public/adminLTE/dist/css/sweetalert.min.js"></script>  
    
	<script src="https://js.pusher.com/4.1/pusher.min.js"></script>

	<?php if(Auth::user()->group=="MANAGER" || Auth::user()->group=="IT"): ?>
	  <script>
		var pusher = new Pusher('<?php echo e(env("MIX_PUSHER_APP_KEY")); ?>', {
		  cluster: '<?php echo e(env("PUSHER_APP_CLUSTER")); ?>',
		  encrypted: true
		});

		var channel = pusher.subscribe('notify-channel');
		channel.bind('App\\Events\\Notify', function(data) {
		  //alert(data.message);
		  swal('Pusher', data.message,'info');
		});
		
	  </script>	
	<?php endif; ?>    
    

    <style>
          ::-webkit-scrollbar {
				width: 5px;
			}

			::-webkit-scrollbar-track {
				-webkit-box-shadow: inset 0 0 6px rgba(0,0,255,0.3); 
				border-radius: 10px;
			}

			::-webkit-scrollbar-thumb {
				border-radius: 10px;
				-webkit-box-shadow: inset 0 0 6px rgba(0,0,255,0.9); 
			}

        #menuUtama { font-size : 13px; }
        #menuUtama a:hover { 
            border-left: 2px rgb(53, 88, 247) solid; 
            background : rgb(217, 242, 243) ;
        }
      
        .tblheader {
 			background: #2F4F4F;
			color: white;
			font-size: 15px;
			alignment: center;           
        }
		
        .notification {
          background-color: blue;
          color: white;
          text-decoration: none;
          padding: 7px 11px;
          position: absolute;
          top: 60px;
          right:80px;
          display: inline-block;
          border-radius: 2px;
        }
        
        .notification:hover {
          background: yellow;
        }
        
        .notification .badge {
          position: absolute;
          top: -4px;
          right: -10px;
          padding: 4px 7px;
          border-radius: 50%;
          background-color: red;
          color: white;
        }
        
        .dataTables_wrapper .dataTables_filter,
        .dataTables_wrapper .dataTables_length,
        .dataTables_wrapper .dataTables_info,
        .dataTables_wrapper .dataTables_page,        
        .dataTables_wrapper .ui-button {
            font-size:14px;
            padding: 0px;
            }
        
        /* change "height" caused by exaggerated padding */
        .dataTables_wrapper .ui-toolbar {
                padding: 0px;
            }        
            
        .table td { font-size:15px; }
        
        .btn-success, .btn-danger, .btn-primary, .btn-warning, .btn-info {border:1px solid black; color:black; background-color:white;}
        
        .btn-success:hover {background-color: #90EE90; }
        .btn-primary:hover {background-color: #87CEEB; }
        .btn-danger:hover { background-color: #F08080; }
        .btn-warning:hover { background-color: #FFA07A; }
        .btn-info:hover { background-color: #DDA0DD; }
		
    </style>
</head>

<body class="hold-transition skin-black-light  sidebar-mini">
<div class="wrapper">

   <!-- Header -->
  <header class="main-header">

    <a href="#" class="logo">
		<span class="logo-mini"><b>MyProject</b></span>
		<span class="logo-lg"><b>MyProject </b>System</span> 
    </a>

    <nav class="navbar navbar-static-top" role="navigation">
<!--------
    <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
        <img src="<?php echo e(asset('logo.png')); ?>" style="width:25px;height:25px;">
        <font size="3" face="verdana">  Wawan </font>
         <span class="sr-only">Toggle navigation </span>      
    </a>
--->

   <a href="#" data-toggle="offcanvas" role="button" style="height:45px;width:50px;">
        <img src="<?php echo e(asset('logo.png')); ?>" style="width:30px;height:30px; margin-top:10px;margin-left:10px">
         <span class="sr-only">Toggle navigation </span>      
    </a>

                
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">

          <li class="dropdown user user-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                <img src="<?php echo e(asset('public/images/admin.png')); ?>" class="user-image" alt="User Image">
                <span class="hidden-xs"><?php echo e(Auth::user()->username); ?></span>
            </a>
            
            <ul class="dropdown-menu">
                <li class="user-header">
                    <img src="<?php echo e(asset('public/images/admin.png')); ?>" class="img-circle" alt="User Image">

                    <p>
                      <?php echo e(Auth::user()->username); ?>

					  <?php echo e(Auth::user()->group); ?>

                    </p>
                </li>
                <li class="user-footer">
                    <div class="pull-left">
                        <a class="btn btn-default btn-flat" href="<?php echo e(route('user.profil')); ?>">Edit Profil</a>
                    </div>
                    <div class="pull-right">
                        <a class="btn btn-default btn-flat" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"> Logout
                        </a>
                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                            <?php echo e(csrf_field()); ?>

                        </form>
                    </div>
                </li>

            </ul>
          </li>
        </ul>
      </div>
    </nav>
  </header>
  <!-- End Header -->


  <!-- Sidebar -->
  <aside class="main-sidebar">

    <section class="sidebar">
      <ul class="sidebar-menu" id="menuUtama">
      <li class="header"></li>

        <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-dashboard"></i> <span>Dashboard</span></a></li>

		<li class="treeview">
		  <a href="#"><i class="fa fa-paste"></i> <span><strong>Master</strong></span> <i class="fa fa-caret-down pull-right"></i></a>
		    <ul class="treeview-menu">
				<li><a href="<?php echo e(route('category.index')); ?>"><i class="fa fa-cogs"></i> <span>Category</span></a></li>		        
				<li><a href="<?php echo e(route('product.index')); ?>"><i class="fa fa-barcode"></i> <span>Master Product</span></a></li>
				<li><a href="<?php echo e(route('supplier.index')); ?>"><i class="fa fa-truck"></i> <span>Master Supplier</span></a></li>
				<li><a href="<?php echo e(route('customer.index')); ?>"><i class="fa fa-male"></i> <span>Data Customer</span></a></li>
				<li><a href="<?php echo e(route('rute.index')); ?>"><i class="fa fa-map-marker"></i> <span>Master Route</span></a></li>

			</ul>
		</li>	 

        <?php if(Auth::user()->group=="MANAGER"): ?>
		<li class="treeview">
		  <a href="#"><i class="fa fa-shopping-bag"></i> <span><strong>Barang Masuk/Pembelian</strong></span> <i class="fa fa-caret-down pull-right"></i></a>
		    <ul class="treeview-menu">
    		<li><a href="<?php echo e(route('invoice.index')); ?>"><i class="fa fa-shopping-cart"></i> <span>Pembelian Baru</span></a></li>
    		<li><a href="<?php echo e(route('invoice.history')); ?>"><i class="fa fa-history"></i> <span>History Pembelian</span></a></li>
            </ul>
        </li>
        <?php endif; ?>

        <li class="treeview">
		  <a href="#"><i class="fa fa-send-o"></i> <span><strong>Transaksi</strong></span> <i class="fa fa-caret-down pull-right"></i></a>
		    <ul class="treeview-menu">            
		    <li><a href="<?php echo e(route('penjualan.index')); ?>"><i class="fa fa-dollar"></i> <span>Penjualan / Retur</span></a></li>
		    <li><a href="<?php echo e(route('penjualan.history')); ?>"><i class="fa fa-calendar"></i> <span>History Penjualan</span></a></li>
		    <li><a href="<?php echo e(route('formbs.index')); ?>"><i class="fa fa-list-alt"></i> <span>Form BS</span></a></li> 
		    </ul>
		 </li>

       <li class="treeview">
		  <a href="#"><i class="fa fa-file-text"></i> <span><strong>Tagihan</strong></span> <i class="fa fa-caret-down pull-right"></i></a>
		    <ul class="treeview-menu">            
		    <li><a href="<?php echo e(route('penjualan.tagihan')); ?>"><i class="fa fa-file-text-o"></i> <span>Create Tagihan</span></a></li>
		    <li><a href="<?php echo e(route('penjualan.history_tagihan')); ?>"><i class="fa fa-calendar"></i> <span>History Tagihan</span></a></li>
		    </ul>
		 </li>
        
        <!---- tidak dipake 
         <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-file-o"></i> <span><strong>Pembayaran Hutang Supplier</strong> </span></a></li>
         --->
         
        <li class="treeview">
		  <a href="#"><i class="fa fa-files-o"></i> <span><strong>Pelunasan Customer</strong></span> <i class="fa fa-caret-down pull-right"></i></a>
		    <ul class="treeview-menu">            
		    <li><a href="<?php echo e(route('piutang.index')); ?>"><i class="fa fa-files-o"></i> <span>Pelunasan Full </span></a></li>
		    <li><a href="<?php echo e(route('piutang.index_cicil')); ?>"><i class="fa fa-history"></i> <span>Pembayaran Sebagian</span></a></li>
		    <li><a href="<?php echo e(route('piutang.history')); ?>"><i class="fa fa-calendar"></i> <span>History Pelunasan</span></a></li>
		    </ul>
		 </li>
		 
		<li class="treeview">
		  <a href="#"><i class="fa fa-cubes"></i> <span><strong>Data Stock</strong></span> <i class="fa fa-caret-down pull-right"></i></a>
		    <ul class="treeview-menu">
	        <li><a href="<?php echo e(route('stock.index')); ?>"><i class="fa fa-cubes"></i> <span>History Stock</span></a></li>
	        <li><a href="<?php echo e(route('stockopname.index')); ?>"><i class="fa fa-shopping-bag"></i> <span>Stock Opname</span></a></li>
    		<li><a href="<?php echo e(route('stockopname.printform')); ?>"><i class="fa fa-print"></i> <span>Print Form Opname</span></a></li>
    		<li><a href="<?php echo e(route('stockopname.history')); ?>"><i class="fa fa-calendar"></i> <span>History Stock Opname</span></a></li>
      		<li><a href="<?php echo e(route('mutasi.index')); ?>"><i class="fa fa-history"></i> <span>Mutasi Stock Kemasan</span></a></li>  
    		<li><a href="<?php echo e(route('stock.change_sts')); ?>"><i class="fa fa-exchange"></i> <span>Ubah Status Stock</span></a></li>
            </ul>
        </li>	
        
        <?php if(Auth::user()->group=="MANAGER"): ?>
		<li class="treeview">
		  <a href="#"><i class="fa fa-shopping-bag"></i> <span><strong>Report</strong></span> <i class="fa fa-caret-down pull-right"></i></a>
		    <ul class="treeview-menu">
    		<li><a href="<?php echo e(route('report.index_sale')); ?>"><i class="fa fa-file-pdf-o"></i> <span>Report Penjualan Rekap</span></a></li>
    		<li><a href="<?php echo e(route('report.index_saledetail')); ?>"><i class="fa fa-file-excel-o"></i> <span>Report Penjualan Detail</span></a></li>
    		<li><a href="<?php echo e(route('report.index_beli')); ?>"><i class="fa fa-truck"></i> <span>Report Pembelian</span></a></li>
    		<li><a href="<?php echo e(route('report.index_lunas')); ?>"><i class="fa fa-dollar"></i><span>Report Pelunasan Customer</span></a></li>

            </ul>
        </li>		
        <?php endif; ?>
        
      	<li><a href="<?php echo e(route('setor.index')); ?>"><i class="fa fa-money"></i><span><strong>SETORAN BANK</strong></span></a></li>   		 

      	<?php if(Auth::user()->group=="MANAGER" || Auth::user()->group=="IT"): ?>
      	<li class="treeview">
		  <a href="#"><i class="fa fa-wrench"></i> <span><strong>Manager Utility</strong></span> <i class="fa fa-caret-down pull-right"></i></a>
		    <ul class="treeview-menu">
        	<li><a href="<?php echo e(route('user.index_logs')); ?>"><i class="fa fa-binoculars"></i><span>History Activity </span></a></li>
        	<li><a href="<?php echo e(route('penjualan.index_unpost')); ?>"><i class="fa fa-unlock"></i><span>Unposting Penjualan</span></a></li>
        	<li><a href="<?php echo e(route('user.index')); ?>"><i class="fa fa-user"></i> <span>User</span></a></li>
        	<!--li><a href="<?php echo e(route('export.tes_excel')); ?>"><i class="fa fa-file-o"></i> <span>Tes Export to Excell</span></a></li-->       
        	<li><a href="<?php echo e(route('penjualan.transferxls')); ?>"><i class="fa fa-file-excel-o"></i><span>Transfer Penjualan to XLS</span></a></li>
        	<li><a href="<?php echo e(route('penjualan.import')); ?>"><i class="fa fa-file-excel-o"></i><span>Import Data Penjualan XLS</span></a></li>
            </ul>
        </li>

        <?php endif; ?>

        <li><a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
			<i class="fa fa-power-off"></i><span>Logout </span></a></li>
        
        <?php if(Auth::user()->username=='alfredo'): ?>
            <li><a href="<?php echo e(route('notification.sendmessage')); ?>"><i class="fa fa-file-o"></i> <span>Test Pusher</span></a></li>           
        <?php endif; ?>
        
    </section>
  </aside>
  <!-- End Sidebar -->

  <!-- Content  -->
  <div class="content-wrapper">
  <section class="content-header"> 
      <font size="4">
        <?php echo $__env->yieldContent('title'); ?>
      </font>
      <ol class="breadcrumb">
        <?php $__env->startSection('breadcrumb'); ?>
        <li><a href="#"><i class="fa fa-home"></i>Home</a></li>
        <?php echo $__env->yieldSection(); ?>
      </ol>
   </section> 

    <section class="content">
        <?php echo $__env->yieldContent('content'); ?>
    </section>
  </div>
  <!-- End Content -->

  <!-- Footer -->

  <footer class="main-footer">
    <div class="pull-right hidden-xs">
       Management System
	</div>
       <strong>Copyright &copy; 2020 <a href="#">My Project</a></strong> All rights reserved.
  </footer>
  <!-- End Footer -->
 
<script src="<?php echo e(asset('public/adminLTE/plugins/jQuery/jquery-2.2.3.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/adminLTE/bootstrap/js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/adminLTE/dist/js/app.min.js')); ?>"></script>

<script src="<?php echo e(asset('public/adminLTE/plugins/chartjs/Chart.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/adminLTE/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/adminLTE/plugins/datatables/dataTables.bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/adminLTE/plugins/datepicker/bootstrap-datepicker.js')); ?>"></script>
<script src="<?php echo e(asset('public/js/validator.min.js')); ?>"></script>

<?php echo $__env->yieldContent('script'); ?>

</body>
</html><?php /**PATH /home/myprojeq/public_html/wawan/resources/views/layouts/app.blade.php ENDPATH**/ ?>