var CACHE_NAME = 'swa-v2';
var filesToCache = [
    './?v1',
	'index.php?v2',
	'offline.html?v2',
    'sw.js?v2',
    'manifest.json?v2',
    'A2HS.js?v2',
    'Logo.png?v2',
    'logo192.png?v2',
    'logo256.png?v2',
    'logo512.png?v2'	
];

/*--------- yg ini tidak tampil A2HS -------------*/
/*
self.addEventListener('install', function(event) {
    console.log('installing service worker');
    event.waitUntil(
        caches.open(CACHE_NAME)
            .then(function(cache) {
                console.log('cache opened');
                var x = cache.addAll(urlsToCache);
                console.log('cache added');
                return x;
            })
    );
});


self.addEventListener('fetch', function(event) {
  event.respondWith(
    caches.match(event.request).then(function(response) {
        return fetch(event.request).then(function(response) {
      if (response.status === 404) {
			//    return caches.match('offline.blade.php');
			  console.log("Offline");
			event.respondWith(pullFromCache(event));
        }
        return response
      });
    }).catch(function() {
      return caches.match('index.html');
    })
  );
});


function pullFromCache(event) {
  return caches.match(event.request).then((response) => {
    return caches.open(CACHE_NAME).then((cache) => {
          cache.put(event.request, response.clone());
          return response;
        });
  });
}

*/
/*----------------------------------------------------------------*/


self.addEventListener('install', function(e) {
	console.log('[ServiceWorker] Install');
	e.waitUntil(
		caches.open(CACHE_NAME).then(function(cache) {
			console.log('[ServiceWorker] Caching app shell');
				return cache.addAll(filesToCache);
		})
		.then(function() {
			console.log('Service Worker Skip waiting on install');
			return self.skipWaiting();
		})
	);
});

self.addEventListener('activate', function(e) {
	console.log('[ServiceWorker] Activate');
	e.waitUntil(
		caches.keys().then(function(keyList) {
			return Promise.all(keyList.map(function(key) {
				if (key !== CACHE_NAME){
					console.log('[ServiceWorker] Removing old cache', key);
					return cache.delete(key);
				}
			}));
		})
	);
	return self.clients.claim();
});

self.addEventListener('fetch', function(e) {
	console.log('[ServiceWorker] Fetch', e.request.url);
	e.respondWith(
		caches.match(e.request).then(function(response) {
			return response || fetch(e.request);
		})
	);
});	


/*  ------------- */
